package com.liquidnet.service.adam.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value = "AdamCollectParam", description = "添加收藏入参")
@Data
public class AdamDisposedParam implements java.io.Serializable {
    private static final long serialVersionUID = 7397579764049783649L;
    @ApiModelProperty(position = 11, required = true, value = "内容ID[64]")
    private String contentId;
    @ApiModelProperty(position = 12, required = true, value = "内容类型", allowableValues = "VIDEO,TICKET,SITE,ARTIST,BAND,BRAND,STYLE,GOODS,MUSIC,SONG")
    private String type;
    @ApiModelProperty(position = 13, required = true, value = "内容标题[255]", example = "13111111111")
    private String contentTitle;
    @ApiModelProperty(position = 14, required = true, value = "内容快照[255]", example = "北京")
    private String contentImg;
    @ApiModelProperty(position = 15, required = false, value = "持续时间,单位S,VIDEO类型时必传[30]", example = "100")
    private Long duration;
}
