package com.liquidnet.service.feign.stone.api;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.stone.dto.StoneScoreListDto;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * <p>
 * 积分接口
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-11-02
 */
@Component
@FeignClient(
        name = "liquidnet-service-stone",
        contextId = "FeignStoneIntegralClient",
        path = "",
        url = "${liquidnet.service.stone.url}",
        fallback = FallbackFactory.Default.class
)
public interface FeignStoneIntegralClient {

    // 用户积分数据
    @GetMapping("user/info")
    ResponseDto<StoneScoreListDto> stoneUserInfo();

    // 增加积分
    @PostMapping("user/logs/in2111")
    ResponseDto<StoneScoreListDto> in2111(
            @RequestParam(value = "uid") String uid,
            @RequestParam(value = "score") Integer score,
            @RequestParam(value = "content") String content
    );

    // 减少积分
    @PostMapping("user/logs/de2111")
    ResponseDto<StoneScoreListDto> de2111(
            @RequestParam(value = "uid") String uid,
            @RequestParam(value = "score") Integer score,
            @RequestParam(value = "content") String content
    );

}
