package com.liquidnet.service.feign.reconciliation.task;

import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.feign.reconciliation.constant.FeignReconConstant;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: 对账Task
 * @class: FeignTaskReconAccountCheckClient
 * @Package com.liquidnet.service.feign.reconciliation.task
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/12/14 11:50 上午
 */
@Service
@FeignClient(name = FeignReconConstant.LIQUIDNET_SERVICE,
        contextId = FeignReconConstant.CONTEXT_RECON_TASK,
        fallback = FallbackFactory.Default.class)
public interface FeignTaskReconAccountCheckClient {
    @PostMapping(value = "/recon/task/accountCheck")
    public void accountCheck(@RequestParam String bankChannel,@RequestParam String billDate);
}
