package com.liquidnet.service.adam.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.io.Serializable;
import java.util.List;

@ApiModel(value = "AdamMemberParam", description = "添加会员参数")
@Data
public class AdamMemberParam implements Serializable {
    private static final long serialVersionUID = -7411934614249221021L;
    @ApiModelProperty(position = 0, required = false, value = "会员ID[50]", example = "62960077673504768")
    private String memberId;

    /**
     * 会员卡名称
     */
    @ApiModelProperty(position = 1, required = false, value = "会员名称[50]", example = "摩登天空会员卡")
    private String name;

    /**
     * 标题
     */
    @ApiModelProperty(position = 2, required = true, value = "会员标题[50]", example = "摩登天空会员卡")
    private String title;

    /**
     * 副标题
     */
    @ApiModelProperty(position = 3, required = true, value = "会员副标题[50]", example = "摩登天空会员卡副标题")
    private String subTitle;

    /**
     * 图标
     */
    @ApiModelProperty(position = 4, required = true, value = "icon图标[200]", example = "https://img.zhengzai.tv/files/2020/08/28/5f490418d30b4.png")
    private String icon;

    /**
     * 头像
     */
    @ApiModelProperty(position = 5, required = true, value = "会员头像[200]", example = "https://img.zhengzai.tv/files/2020/08/31/5f4c75095e9bc.pngv")
    private String avatar;

    /**
     * 权益详情
     */
    @ApiModelProperty(position = 6, required = true, value = "权益详情[200]", example = "加入摩登天空会员您可享受到.....")
    private String interestsDetail;

    /**
     * 注意事项
     */
    @ApiModelProperty(position = 7, required = true, value = "注意事项[200]", example = "摩登天空会员需注意以下事项.....")
    private String notes;

    /**
     * '是否展示须知'
     */
    @ApiModelProperty(position = 8, required = true, value = "是否展示须知[[0-否,1-是]]", allowableValues = "0,1")
    private Integer isNotice;

    /**
     * 须知内容
     */
    @ApiModelProperty(position = 9, required = true, value = "会员须知内容[200]", example = "会员须知细则1.xxxx\n2.xxxx")
    private String noticeInfo;

    /**
     * 须知标题
     */
    @ApiModelProperty(position = 10, required = true, value = "会员须知标题[200]", example = "摩登天空会员须知")
    private String noticeTitle;

    /**
     * 是否需要答题 0不需要 1需要
     */
    @ApiModelProperty(position = 11, required = true, value = "是否需要答题[0-否,1-是]", allowableValues = "0,1")
    private Integer needQuestion;

    /**
     * 是否展示协议 0否1是
     */
    @ApiModelProperty(position = 12, required = true, value = "是否展示协议[0-否,1-是]", allowableValues = "0,1")
    private Integer displayAgreement;

    /**
     * 会员协议
     */
    @ApiModelProperty(position = 13, required = true, value = "会员协议内容[200]", example = "摩登天空会员协议须知....")
    private String agreement;

    /**
     * 限购数量
     */
    @ApiModelProperty(position = 14, required = true, value = "限购数量，0不限购[200]", example = "0")
    private Integer limitation;

    @ApiModelProperty(position = 15, required = true, value = "会员卡价格ID", example = "[63666042953703424]")
    private List<String> memberPriceList;
}
