package com.liquidnet.service.kylin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@ApiModel(value = "KylinStationPerformanceVo", description = "演出列表响应参数")
@Data
public class KylinStationPerformanceVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -4994363974994478286L;
    @ApiModelProperty(position = 10, value = "演出ID[64]")
    private String performanceId;
    @ApiModelProperty(position = 11, value = "类型[101-音乐节,102小型演出(livehouse演出),103巡演]")
    private Integer type;
    @ApiModelProperty(position = 12, value = "演出标题[255]")
    private String title;
    @ApiModelProperty(position = 13, value = "开始时间[yyyy/MM/dd]")
    private String timeStart;
    @ApiModelProperty(position = 14, value = "结束时间[yyyy/MM/dd]")
    private String timeEnd;
    @ApiModelProperty(position = 15, value = "票种列表信息")
    private List<KylinStationTicketVo> ticketVoList;

    private static final KylinStationPerformanceVo obj = new KylinStationPerformanceVo();

    public static KylinStationPerformanceVo getNew() {
        try {
            return (KylinStationPerformanceVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinStationPerformanceVo();
        }
    }
}
