package com.liquidnet.service.goblin.controller.manage;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.PagedResult;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.*;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtCouponInfoVo;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtCouponListVo;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtGoodsInfoVo;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtGoodsListVo;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@ApiSupport(order = 149006)
@Api(tags = "商铺活动:优惠券管理")
@Slf4j
@Validated
@RestController
@RequestMapping("store/mgt/coupon")
public class GoblinStoreMgtCouponController {
    @Autowired
    GoblinRedisUtils goblinRedisUtils;
    @Autowired
    GoblinMongoUtils goblinMongoUtils;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "优惠券列表")
    @PostMapping("list")
    public ResponseDto<PagedResult<GoblinStoreMgtCouponListVo>> list(@Valid @RequestBody GoblinStoreMgtCouponFilterParam mgtCouponFilterParam) {
        if (log.isDebugEnabled()) {
            log.debug("商铺活动:优惠券列表:[mgtCouponFilterParam={}]", JsonUtils.toJson(mgtCouponFilterParam));
        }
        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "优惠券导出", notes = "#以POST模拟FORM表单请求该接口")
    @PostMapping("export")
    public void export(@Valid GoblinStoreMgtCouponFilterParam mgtCouponFilterParam) {
        if (log.isDebugEnabled()) {
            log.debug("商铺活动:优惠券导出:[mgtCouponFilterParam={}]", JsonUtils.toJson(mgtCouponFilterParam));
        }
    }

    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "优惠券管理", notes = "#以POST模拟FORM表单请求该接口")
    @PostMapping("action")
    public ResponseDto<Object> action(@Valid GoblinStoreMgtCouponActionParam mgtCouponActionParam) {
        String currentUid = CurrentUtil.getCurrentUid();
        if (!goblinRedisUtils.hasStoreId(currentUid, mgtCouponActionParam.getStoreId())) {
            return ResponseDto.failure(ErrorMapping.get("149002"));
        }
        if (log.isDebugEnabled()) {
            log.debug("商铺活动:优惠券管理:[GoblinStoreMgtCouponActionParam={}]", JsonUtils.toJson(mgtCouponActionParam));
        }

        switch (mgtCouponActionParam.getAction()) {
            case "ONSHELVES":
//                mgtCouponActionParam.goodsShelvesProcessing(mgtCouponActionParam, currentUid, true);
                break;
            case "UNSHELVE":
//                mgtCouponActionParam.goodsShelvesProcessing(mgtCouponActionParam, currentUid, false);
                break;
            case "REMOVE":
//                mgtCouponActionParam.goodsRemove(mgtCouponActionParam, currentUid);
                break;
            default:
                log.warn("商铺活动:优惠券管理:Invalid operation[UID={},storeMgtGoodsActionParam={}]", currentUid, JsonUtils.toJson(mgtCouponActionParam));
                return ResponseDto.failure(ErrorMapping.get("149001"));
        }
        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 4)
    @ApiOperation(value = "新增优惠券")
    @PutMapping("add")
    public ResponseDto<Object> add(@Valid @RequestBody GoblinStoreMgtCouponAddParam mgtCouponAddParam) {
        if (log.isDebugEnabled()) {
            log.debug("商铺活动:新增优惠券:[mgtCouponAddParam={}]", JsonUtils.toJson(mgtCouponAddParam));
        }
        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 5)
    @ApiOperation(value = "优惠券详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "店铺ID"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeCouponId", value = "优惠券ID"),
    })
    @GetMapping("info")
    public ResponseDto<GoblinStoreMgtCouponInfoVo> info(@NotBlank(message = "店铺ID不能为空") @RequestParam String storeId,
                                                        @NotBlank(message = "优惠券ID不能为空") @RequestParam String storeCouponId) {
        if (!goblinRedisUtils.hasStoreId(CurrentUtil.getCurrentUid(), storeId)) {
            return ResponseDto.failure(ErrorMapping.get("149002"));
        }
        if (log.isDebugEnabled()) {
            log.debug("商铺活动:优惠券详情:[storeId={},storeCouponId={}]", storeId, storeCouponId);
        }
        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 6)
    @ApiOperation(value = "优惠券编辑", notes = "只修改基本信息，不包含发放设置修改")
    @PostMapping("edit")
    public ResponseDto<Object> edit(@Valid @RequestBody GoblinStoreMgtCouponAddParam mgtCouponEditParam) {
        log.info("商铺活动:优惠券编辑:[mgtCouponEditParam={}]", JsonUtils.toJson(mgtCouponEditParam));
        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 7)
    @ApiOperation(value = "优惠券库存编辑")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeId", value = "店铺ID"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "storeCouponId", value = "优惠券ID"),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "stock", value = "增减库存"),
    })
    @PostMapping("edit_stock")
    public ResponseDto<Object> editStock(@NotBlank(message = "店铺ID不能为空") @RequestParam String storeId,
                                         @NotBlank(message = "优惠券ID不能为空") @RequestParam String storeCouponId,
                                         @NotNull(message = "增减库存值不能为空") @RequestParam Integer stock) {
        log.info("商铺活动:优惠券库存编辑:[storeId={},storeCouponId={},stock={}]", storeId, storeCouponId, stock);
        return ResponseDto.success();
    }
}
