package com.liquidnet.service.slime.dto.param;

import com.liquidnet.commons.lang.constant.LnsRegex;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import java.io.Serializable;

@ApiModel(value = "SlimeStationCheckOrderParam", description = "上载验票入参")
@Data
public class SlimeStationCheckOrderParam implements Serializable {
    private static final long serialVersionUID = -6456177634242162305L;
    @ApiModelProperty(position = 10, value = "票明细ID")
    @NotBlank(message = "票明细ID不能为空")
    private String ticketEntitiesId;
    @ApiModelProperty(position = 11, value = "验票类型:1-扫码,2-手机号")
    private String checkType;
    @ApiModelProperty(position = 12, value = "验票时间[yyyy-MM-dd HH:mm:ss]")
    @NotBlank(message = "验票时间不能为空")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_FULL, message = "验票时间格式有误")
    private String checkedAt;
    @ApiModelProperty(position = 13, value = "验票操作人ID")
    @NotBlank(message = "验票操作人不能为空")
    private String checkUserId;
}
