package com.liquidnet.service.goblin.dto.vo;

import com.liquidnet.service.goblin.entity.GoblinNftOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * NFT订单表
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-03-24
 */
@ApiModel(value = "GoblinNftOrderVo", description = "订单详情信息")
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinNftOrderVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "订单id")
    private String orderId;

    @ApiModelProperty(value = "商品id")
    private String spuId;

    @ApiModelProperty(value = "款式id")
    private String skuId;

    @ApiModelProperty(value = "数量")
    private Integer num;

    @ApiModelProperty(value = "店铺id")
    private String storeId;

    @ApiModelProperty(value = "商铺名称")
    private String storeName;

    @ApiModelProperty(value = "订单号")
    private String orderCode;

    @ApiModelProperty(value = "用户id")
    private String userId;

    @ApiModelProperty(value = "用户昵称")
    private String userName;

    @ApiModelProperty(value = "用户手机号")
    private String userMobile;

    @ApiModelProperty(value = "是否会员")
    private Integer isMember;

    @ApiModelProperty(value = "应付金额")
    private BigDecimal priceTotal;

    @ApiModelProperty(value = "券优惠金额")
    private BigDecimal priceCoupon;

    @ApiModelProperty(value = "商铺券优惠金额")
    private BigDecimal storePriceCoupon;

    @ApiModelProperty(value = "红包优惠金额")
    private BigDecimal priceRedEnvelope;

    @ApiModelProperty(value = "总优惠价格")
    private BigDecimal priceVoucher;

    @ApiModelProperty(value = "实付金额")
    private BigDecimal priceActual;

    @ApiModelProperty(value = "券id")
    private String ucouponId;

    @ApiModelProperty(value = "商铺券id")
    private String storeCouponId;

    @ApiModelProperty(value = "红包code")
    private String redEnvelopeCode;

    @ApiModelProperty(value = "订单状态 1待付款 2已付款 3未付款取消订单 4退款中 5已退款")
    private Integer status;

    @ApiModelProperty(value = "订单来源 app|h5|applet")
    private String source;

    @ApiModelProperty(value = "订单类型 1购买订单 2兑换订单 3演出赠送订单")
    private Integer orderType;

    @ApiModelProperty(value = "支付时间")
    private LocalDateTime payTime;

    @ApiModelProperty(value = "支付单号")
    private String payCode;

    @ApiModelProperty(value = "支付类型 wepay微信 alipay阿里 douyinpay抖音 unionpay银联")
    private String payType;

    @ApiModelProperty(value = "支付终端 app wap js applet")
    private String deviceFrom;

    @ApiModelProperty(value = "支付中心返回实际支付类型")
    private String paymentType;

    @ApiModelProperty(value = "支付中心返回支付id")
    private String paymentId;

    @ApiModelProperty(value = "钱到了哪个支付平台  平台的订单id为")
    private String payStoreId;

    @ApiModelProperty(value = "订单过期时间(分钟)")
    private Integer payCountdownMinute;

    @ApiModelProperty(value = "取消原因")
    private String cancelReason;

    @ApiModelProperty(value = "取消时间")
    private LocalDateTime cancelTime;

    @ApiModelProperty(value = "版本号")
    private String version;

    @ApiModelProperty(value = "ip地址")
    private String ipAddress;

    @ApiModelProperty(value = "ip地域全名称")
    private String area;

    @ApiModelProperty(value = "ip地域省")
    private String areaProvince;

    @ApiModelProperty(value = "ip地域市")
    private String areaCity;

    @ApiModelProperty(value = "ip地域县")
    private String areaCounty;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createdAt;

    @ApiModelProperty(value = "更新时间")
    private LocalDateTime updatedAt;

    public GoblinNftOrderVo copy(GoblinNftOrder source) {
        if (null == source) return this;
        this.setSpuId(source.getSpuId());
        this.setSkuId(source.getSkuId());
        this.setNum(source.getNum());
        this.setOrderId(source.getOrderId());
        this.setStoreId(source.getStoreId());
        this.setStoreName(source.getStoreName());
        this.setOrderCode(source.getOrderCode());
        this.setPayCode(source.getPayCode());
        this.setUserId(source.getUserId());
        this.setUserName(source.getUserName());
        this.setUserMobile(source.getUserMobile());
        this.setPriceTotal(source.getPriceTotal());
        this.setPriceActual(source.getPriceActual());
        this.setPriceCoupon(source.getPriceCoupon());
        this.setStorePriceCoupon(source.getStorePriceCoupon());
        this.setPriceVoucher(source.getPriceVoucher());
        this.setStatus(source.getStatus());
        this.setUcouponId(source.getUcouponId());
        this.setStoreCouponId(source.getStoreCouponId());
        this.setPayType(source.getPayType());
        this.setDeviceFrom(source.getDeviceFrom());
        this.setCancelReason(source.getCancelReason());
        this.setSource(source.getSource());
        this.setVersion(source.getVersion());
        this.setIsMember(source.getIsMember());
        this.setOrderType(source.getOrderType());
        this.setPayCountdownMinute(source.getPayCountdownMinute());
        this.setIpAddress(source.getIpAddress());
        this.setPaymentId(source.getPaymentId());
        this.setPaymentType(source.getPaymentType());
        this.setCreatedAt(source.getCreatedAt());
        return this;
    }

    private static final GoblinNftOrderVo obj = new GoblinNftOrderVo();

    public static GoblinNftOrderVo getNew() {
        try {
            return (GoblinNftOrderVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinNftOrderVo();
        }
    }
}
