package com.liquidnet.service.platform.controller.A_fskfsfs;


import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.mysql.cj.jdbc.result.ResultSetImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;

/**
 * 临时数据处理
 *
 * @author jiangxiulong
 */
@Api(tags = "临时数据处理")
@RestController
@RequestMapping("fskfsfs")
@Slf4j
public class JxlDataKylinSearchController {

    @Value("${spring.datasource.url}")
    private String SQL_URL;
    @Value("${spring.datasource.username}")
    private String SQL_USER;
    @Value("${spring.datasource.password}")
    private String SQL_PWD;

    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;

    @GetMapping("S001")
    @ApiOperation("确认某演出所有票种库存")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "performancesId", value = "演出id", required = true),
    })
    public ResponseDto P001(
            @RequestParam("performancesId") String performancesId
    ) {
        try {
            String sql = "select cc.title as per_title, dd.title as time_title, ee.title ticket_title, bb.ticket_id, ff.*\n" +
                    "from kylin_ticket_time_relation as aa\n" +
                    "         join kylin_ticket_relations as bb on aa.times_id = bb.times_id\n" +
                    "         join kylin_performances as cc on cc.performances_id = aa.performance_id\n" +
                    "         join kylin_ticket_times as dd on dd.ticket_times_id = aa.times_id\n" +
                    "         join kylin_tickets as ee on ee.tickets_id = bb.ticket_id\n" +
                    "         join kylin_ticket_status as ff on ff.ticket_id = bb.ticket_id\n" +
                    "where 1 = 1\n" +
                    "  and ff.status <> 7\n" +
                    "  and aa.performance_id = " + performancesId + "\n" +
                    ";";

            Connection connection = DriverManager.getConnection(SQL_URL, SQL_USER, SQL_PWD);
            PreparedStatement preparedStatement = connection.prepareStatement(sql);
            ResultSetImpl row = (ResultSetImpl) preparedStatement.executeQuery();

            while (row.next()) {
                String per_title = row.getString("per_title");
                String time_title = row.getString("time_title");
                String ticket_title = row.getString("ticket_title");
                String ticket_id = row.getString("ticket_id");
                Integer surplus_general = row.getInt("surplus_general");
                Integer surplus_exchange = row.getInt("surplus_exchange");
//                skuVo.setSkuPriceActual(rowSku.getBigDecimal("sku_price_actual"));

                String surplusGeneralKey = KylinRedisConst.PERFORMANCES_INVENTORY + ticket_id + ":" + KylinRedisConst.SURPLUS_GENERAL;
                String surplusExchangeKey = KylinRedisConst.PERFORMANCES_INVENTORY + ticket_id + ":" + KylinRedisConst.SURPLUS_EXCHANGE;
                Integer surplusGeneral = (int) redisDataSourceUtil.getRedisKylinUtil().get(surplusGeneralKey);
                Integer surplusExchange = (int) redisDataSourceUtil.getRedisKylinUtil().get(surplusExchangeKey);

                System.out.println(per_title + " | " + time_title + " | " + ticket_title + " | " + ticket_id + " | " + surplus_general + " | " + surplusGeneral + " | " + surplus_exchange + " | " + surplusExchange);

                if (surplusGeneral == null) {
                    System.out.println("ERROR surplusGeneral null");
                }
                if (surplusExchange == null) {
                    System.out.println("ERROR surplusExchange null");
                }
                if (!surplus_general.equals(surplusGeneral)) {
                    System.out.println("ERROR surplusGeneral 不相等" + surplus_general + "｜" + surplusGeneral);
//                    System.out.println("redis key " + surplusGeneralKey);
                    this.getIndex(surplusGeneralKey);
                }
                if (!surplus_exchange.equals(surplusExchange)) {
                    System.out.println("ERROR surplusExchange 不相等" + surplus_exchange + "｜" + surplusExchange);
//                    System.out.println("redis key " + surplusExchangeKey);
                    this.getIndex(surplusExchangeKey);
                }

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ResponseDto.success();
    }


    public int getIndex(String key) {
        int defaultDb = 0;
        int totalDbs = 256;
        if (totalDbs == 1) {
            log.info("only one db : {} ", defaultDb);
            return defaultDb;
        }
        int mod = 250;
        if (totalDbs > 1 && totalDbs < 256) {
            if (totalDbs == 16) {
                mod = 15;
            } else {
                mod = totalDbs - 1;
            }
        }
        long value = Long.valueOf(key.hashCode());
        int hash = (int) (value ^ (value >>> 32));
        int index = hash % mod;
        System.out.println("redis key｜index "+ key + " | " + index);
        return index;
    }

}
