package com.liquidnet.service.goblin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 商城-名单表
 * </p>
 *
 * @author liquidnet
 * @since 2022-04-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinList implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 名单id
     */
    private String listId;

    /**
     * 用户id
     */
    private String uid;

    /**
     * 名单名称
     */
    private String name;

    /**
     * 白名单类型[0-会员|1-指定用户]
     */
    private Integer whiteType;

    /**
     * 标签[0-提前购买|1-分段购买]
     */
    private Integer tagType;

    /**
     * 白名单xls地址
     */
    private String whiteUrl;

    /**
     * 开始时间
     */
    private LocalDateTime timeStart;

    /**
     * 结束时间
     */
    private LocalDateTime timeEnd;

    /**
     * 黑名单类型[0-会员|1-指定用户]
     */
    private Integer blackType;

    /**
     * 黑名单xls地址
     */
    private String blackUrl;

    /**
     * 补充字段
     */
    private String comment;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;


}
