package com.liquidnet.service.goblin.controller.manage;

import com.github.pagehelper.PageInfo;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreZhengzaiCommonParam;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.param.GoblinListCreateParam;
import com.liquidnet.service.goblin.param.GoblinListUpdateParam;
import com.liquidnet.service.goblin.service.manage.IGoblinListService;
import com.liquidnet.service.goblin.service.manage.IGoblinZhengzaiService;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 正在下单活动管理
 */
@ApiSupport(order = 149201)
@Slf4j
@RestController
@Api(tags = "活动-名单")
@RequestMapping("store/list")
public class GoblinListController {

    @Autowired
    IGoblinListService goblinListService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "name", value = "活动名称"),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "page", value = "页数"),

    })
    @GetMapping("list")
    public ResponseDto<PageInfo<GoblinListVo>> list(@RequestParam(value = "name", required = false) String name,
                                                    @RequestParam Integer page) {
        return goblinListService.getList(name, page);
    }

    @ApiOperation(value = "详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "listId", value = "名单id"),
    })
    @GetMapping("details")
    public ResponseDto<GoblinListDetailsVo> details(@NotBlank(message = "店铺ID不能为空") @RequestParam String listId) {
        return goblinListService.getDetails(listId);
    }

    @ApiOperation(value = "创建")
    @PostMapping("create")
    public ResponseDto<Boolean> create(@RequestBody GoblinListCreateParam para) {
        return goblinListService.create(para);
    }

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "修改")
    @PutMapping("change")
    public ResponseDto<Boolean> update(@RequestBody GoblinListUpdateParam param) {
        return goblinListService.update(param);
    }

}
