package com.liquidnet.service.consumer.service.processor;

import com.liquidnet.common.mq.constant.MQConst;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.consumer.service.IBaseDao;
import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;
import org.springframework.amqp.core.Message;

import javax.annotation.Resource;
import java.io.IOException;

/**
 * ConsumerProcessor.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2021/4/29
 */
@Slf4j
@Component
public class ConsumerProcessor {
    @Resource
    IBaseDao baseDao;

//    @RabbitListener(bindings = @QueueBinding(
//            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL), key = MQConst.ROUTING_KEY_SQL,
//            value = @Queue(MQConst.QUEUES_SQL_MAIN)
//    ))
////    @RabbitListener(queues = MQConst.QUEUES_SQL_MAIN)
//    public void consumerSql(Message msg, Channel channel) {
//        SqlMapping.SqlMessage sqlMessage = JsonUtils.fromJson(new String(msg.getBody()), SqlMapping.SqlMessage.class);
//        log.debug("consumer sql ==> Preparing:{}", JsonUtils.toJson(sqlMessage.getSqls()));
//        log.debug("consumer sql ==> Parameters:{}", JsonUtils.toJson(sqlMessage.getArgs()));
//
//        try {
//            Boolean rstBatchSqls = baseDao.batchSqls(sqlMessage.getSqls(), sqlMessage.getArgs());
//            log.debug("consumer sql result of execution:{}", rstBatchSqls);
//            if (rstBatchSqls) {
//                channel.basicAck(msg.getMessageProperties().getDeliveryTag(), false);
//            } else {
//                channel.basicReject(msg.getMessageProperties().getDeliveryTag(), true);
//            }
//        } catch (Exception e) {
//            log.error("error:consumer sql:{}", JsonUtils.toJson(sqlMessage), e);
//            try {
//                channel.basicReject(msg.getMessageProperties().getDeliveryTag(), true);
//            } catch (IOException ioException) {
//                log.error("error:consumer sql:basicReject.msg.tag:{}", msg.getMessageProperties().getDeliveryTag(), ioException);
//            }
//        }
//    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EX_LNS_SQL_UCENTER), key = MQConst.RK_SQL_UCENTER,
            value = @Queue(MQConst.QUEUES_SQL_UCENTER)
    ))
    public void consumerSqlForURegister(Message msg, Channel channel) {
        SqlMapping.SqlMessage sqlMessage = JsonUtils.fromJson(new String(msg.getBody()), SqlMapping.SqlMessage.class);
        log.debug("consumer sql ==> Preparing:{}", JsonUtils.toJson(sqlMessage.getSqls()));
        log.debug("consumer sql ==> Parameters:{}", JsonUtils.toJson(sqlMessage.getArgs()));

        try {
            Boolean rstBatchSqls = baseDao.batchSqls(sqlMessage.getSqls(), sqlMessage.getArgs());
            log.debug("consumer sql result of execution:{}", rstBatchSqls);
            if (rstBatchSqls) {
                channel.basicAck(msg.getMessageProperties().getDeliveryTag(), false);
            } else {
                channel.basicReject(msg.getMessageProperties().getDeliveryTag(), true);
            }
        } catch (Exception e) {
            log.error("error:consumer sql:{}", JsonUtils.toJson(sqlMessage), e);
            try {
                channel.basicReject(msg.getMessageProperties().getDeliveryTag(), true);
            } catch (IOException ioException) {
                log.error("error:consumer sql:basicReject.msg.tag:{}", msg.getMessageProperties().getDeliveryTag(), ioException);
            }
        }
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EX_LNS_SQL_UCENTER), key = MQConst.RK_SQL_UREGISTER,
            value = @Queue(MQConst.QUEUES_SQL_UREGISTER)
    ))
    public void consumerSqlForUCenter(Message msg, Channel channel) {
        SqlMapping.SqlMessage sqlMessage = JsonUtils.fromJson(new String(msg.getBody()), SqlMapping.SqlMessage.class);
        log.debug("consumer sql ==> Preparing:{}", JsonUtils.toJson(sqlMessage.getSqls()));
        log.debug("consumer sql ==> Parameters:{}", JsonUtils.toJson(sqlMessage.getArgs()));

        try {
            Boolean rstBatchSqls = baseDao.batchSqls(sqlMessage.getSqls(), sqlMessage.getArgs());
            log.debug("consumer sql result of execution:{}", rstBatchSqls);
            if (rstBatchSqls) {
                channel.basicAck(msg.getMessageProperties().getDeliveryTag(), false);
            } else {
                channel.basicReject(msg.getMessageProperties().getDeliveryTag(), true);
            }
        } catch (Exception e) {
            log.error("error:consumer sql:{}", JsonUtils.toJson(sqlMessage), e);
            try {
                channel.basicReject(msg.getMessageProperties().getDeliveryTag(), true);
            } catch (IOException ioException) {
                log.error("error:consumer sql:basicReject.msg.tag:{}", msg.getMessageProperties().getDeliveryTag(), ioException);
            }
        }
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EX_LNS_SQL_UCENTER), key = MQConst.RK_SQL_UMEMBER,
            value = @Queue(MQConst.QUEUES_SQL_UMEMBER)
    ))
    public void consumerSqlForUMember(Message msg, Channel channel) {
        SqlMapping.SqlMessage sqlMessage = JsonUtils.fromJson(new String(msg.getBody()), SqlMapping.SqlMessage.class);
        log.debug("consumer sql ==> Preparing:{}", JsonUtils.toJson(sqlMessage.getSqls()));
        log.debug("consumer sql ==> Parameters:{}", JsonUtils.toJson(sqlMessage.getArgs()));

        try {
            Boolean rstBatchSqls = baseDao.batchSqls(sqlMessage.getSqls(), sqlMessage.getArgs());
            log.debug("consumer sql result of execution:{}", rstBatchSqls);
            if (rstBatchSqls) {
                channel.basicAck(msg.getMessageProperties().getDeliveryTag(), false);
            } else {
                channel.basicReject(msg.getMessageProperties().getDeliveryTag(), true);
            }
        } catch (Exception e) {
            log.error("error:consumer sql:{}", JsonUtils.toJson(sqlMessage), e);
            try {
                channel.basicReject(msg.getMessageProperties().getDeliveryTag(), true);
            } catch (IOException ioException) {
                log.error("error:consumer sql:basicReject.msg.tag:{}", msg.getMessageProperties().getDeliveryTag(), ioException);
            }
        }
    }

    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EX_LNS_SQL_STATION), key = MQConst.RK_SQL_STATION,
            value = @Queue(MQConst.QUEUES_SQL_STATION)
    ))
    public void consumerSqlForStation(Message msg, Channel channel) {
        SqlMapping.SqlMessage sqlMessage = JsonUtils.fromJson(new String(msg.getBody()), SqlMapping.SqlMessage.class);
        log.debug("consumer sql ==> Preparing:{}", JsonUtils.toJson(sqlMessage.getSqls()));
        log.debug("consumer sql ==> Parameters:{}", JsonUtils.toJson(sqlMessage.getArgs()));

        try {
            Boolean rstBatchSqls = baseDao.batchSqls(sqlMessage.getSqls(), sqlMessage.getArgs());
            log.debug("consumer sql result of execution:{}", rstBatchSqls);
            if (rstBatchSqls) {
                channel.basicAck(msg.getMessageProperties().getDeliveryTag(), false);
            } else {
                channel.basicReject(msg.getMessageProperties().getDeliveryTag(), true);
            }
        } catch (Exception e) {
            log.error("error:consumer sql:{}", JsonUtils.toJson(sqlMessage), e);
            try {
                channel.basicReject(msg.getMessageProperties().getDeliveryTag(), true);
            } catch (IOException ioException) {
                log.error("error:consumer sql:basicReject.msg.tag:{}", msg.getMessageProperties().getDeliveryTag(), ioException);
            }
        }
    }

    // 订单创建
//    @RabbitListener(queues = MQConst.QUEUES_SQL_ORDER_CREATE)
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CREADE),
            key = MQConst.ROUTING_KEY_SQL_ORDER_CREATE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CREATE)
    ))
    public void consumerOrderCreate(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_CREATE   ===");
        SqlMapping.SqlMessage sqlMessage = JsonUtils.fromJson(new String(msg.getBody()), SqlMapping.SqlMessage.class);
        log.debug("consumer sql_order_create ==> Preparing:{}", JsonUtils.toJson(sqlMessage.getSqls()));
        log.debug("consumer sql_order_create ==> Parameters:{}", JsonUtils.toJson(sqlMessage.getArgs()));

        try {
            Boolean rstBatchSqls = baseDao.batchSqls(sqlMessage.getSqls(), sqlMessage.getArgs());
            log.debug("CONSUMER_ORDER_CREATE result of execution:{}", rstBatchSqls);
            if (rstBatchSqls) {
                channel.basicAck(msg.getMessageProperties().getDeliveryTag(), false);
            } else {
                channel.basicReject(msg.getMessageProperties().getDeliveryTag(), true);
            }
        } catch (Exception e) {
            log.error("error:consumer sql2:{}", JsonUtils.toJson(sqlMessage), e);
            try {
                channel.basicReject(msg.getMessageProperties().getDeliveryTag(), true);
            } catch (IOException ioException) {
                log.error("error:consumer sql2:basicReject.msg.tag:{}", msg.getMessageProperties().getDeliveryTag(), ioException);
            }
        }
    }

    //订单再次支付
//    @RabbitListener(queues = MQConst.QUEUES_SQL_ORDER_AGAIN)
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_AGAIN),
            key = MQConst.ROUTING_KEY_SQL_ORDER_AGAIN,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_AGAIN)
    ))
    public void consumerOrderPayAgain(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_PAY_AGAIN   ===");
        SqlMapping.SqlMessage sqlMessage = JsonUtils.fromJson(new String(msg.getBody()), SqlMapping.SqlMessage.class);
        log.debug("consumer sql_order_create ==> Preparing:{}", JsonUtils.toJson(sqlMessage.getSqls()));
        log.debug("consumer sql_order_create ==> Parameters:{}", JsonUtils.toJson(sqlMessage.getArgs()));

        try {
            Boolean rstBatchSqls = baseDao.batchSqls(sqlMessage.getSqls(), sqlMessage.getArgs());
            log.debug("CONSUMER_ORDER_PAY_AGAIN result of execution:{}", rstBatchSqls);
            if (rstBatchSqls) {
                channel.basicAck(msg.getMessageProperties().getDeliveryTag(), false);
            } else {
                channel.basicReject(msg.getMessageProperties().getDeliveryTag(), true);
            }
        } catch (Exception e) {
            log.error("error:consumer sql2:{}", JsonUtils.toJson(sqlMessage), e);
            try {
                channel.basicReject(msg.getMessageProperties().getDeliveryTag(), true);
            } catch (IOException ioException) {
                log.error("error:consumer sql2:basicReject.msg.tag:{}", msg.getMessageProperties().getDeliveryTag(), ioException);
            }
        }
    }

    //订单关闭
//    @RabbitListener(queues = MQConst.QUEUES_SQL_ORDER_CLOSE)
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_CLOSE),
            key = MQConst.ROUTING_KEY_SQL_ORDER_CLOSE,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_CLOSE)
    ))
    public void consumerOrderClose(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_CLOSE   ===");
        SqlMapping.SqlMessage sqlMessage = JsonUtils.fromJson(new String(msg.getBody()), SqlMapping.SqlMessage.class);
        log.debug("consumer sql_order_create ==> Preparing:{}", JsonUtils.toJson(sqlMessage.getSqls()));
        log.debug("consumer sql_order_create ==> Parameters:{}", JsonUtils.toJson(sqlMessage.getArgs()));

        try {
            Boolean rstBatchSqls = baseDao.batchSqls(sqlMessage.getSqls(), sqlMessage.getArgs());
            log.debug("CONSUMER_ORDER_CLOSE result of execution:{}", rstBatchSqls);
            if (rstBatchSqls) {
                channel.basicAck(msg.getMessageProperties().getDeliveryTag(), false);
            } else {
                channel.basicReject(msg.getMessageProperties().getDeliveryTag(), true);
            }
        } catch (Exception e) {
            log.error("error:consumer sql2:{}", JsonUtils.toJson(sqlMessage), e);
            try {
                channel.basicReject(msg.getMessageProperties().getDeliveryTag(), true);
            } catch (IOException ioException) {
                log.error("error:consumer sql2:basicReject.msg.tag:{}", msg.getMessageProperties().getDeliveryTag(), ioException);
            }
        }
    }

    //订单支付
//    @RabbitListener(queues = MQConst.QUEUES_SQL_ORDER_PAY)
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_ORDER_PAY),
            key = MQConst.ROUTING_KEY_SQL_ORDER_PAY,
            value = @Queue(MQConst.QUEUES_SQL_ORDER_PAY)
    ))
    public void consumerOrderPay(Message msg, Channel channel) {
        log.info("===   CONSUMER_ORDER_PAY   ===");
        SqlMapping.SqlMessage sqlMessage = JsonUtils.fromJson(new String(msg.getBody()), SqlMapping.SqlMessage.class);
        log.debug("consumer sql_order_create ==> Preparing:{}", JsonUtils.toJson(sqlMessage.getSqls()));
        log.debug("consumer sql_order_create ==> Parameters:{}", JsonUtils.toJson(sqlMessage.getArgs()));

        try {
            Boolean rstBatchSqls = baseDao.batchSqls(sqlMessage.getSqls(), sqlMessage.getArgs());
            log.debug("CONSUMER_ORDER_PAY result of execution:{}", rstBatchSqls);
            if (rstBatchSqls) {
                channel.basicAck(msg.getMessageProperties().getDeliveryTag(), false);
            } else {
                channel.basicReject(msg.getMessageProperties().getDeliveryTag(), true);
            }
        } catch (Exception e) {
            log.error("error:consumer sql2:{}", JsonUtils.toJson(sqlMessage), e);
            try {
                channel.basicReject(msg.getMessageProperties().getDeliveryTag(), true);
            } catch (IOException ioException) {
                log.error("error:consumer sql2:basicReject.msg.tag:{}", msg.getMessageProperties().getDeliveryTag(), ioException);
            }
        }
    }

    //缺票登记
//    @RabbitListener(queues = MQConst.QUEUES_SQL_PERFORMANCE_LACK)
    @RabbitListener(bindings = @QueueBinding(
            exchange = @Exchange(MQConst.EXCHANGES_LIQUIDNET_SQL_PERFORMANCE_LACK),
            key = MQConst.ROUTING_KEY_SQL_PERFORMANCE_LACK,
            value = @Queue(MQConst.QUEUES_SQL_PERFORMANCE_LACK)
    ))
    public void consumerPerformanceLack(Message msg, Channel channel) {
        log.info("===   CONSUMER_PERFORMANCE_LACK   ===");
        SqlMapping.SqlMessage sqlMessage = JsonUtils.fromJson(new String(msg.getBody()), SqlMapping.SqlMessage.class);
        log.debug("consumer sql_performance_lack ==> Preparing:{}", JsonUtils.toJson(sqlMessage.getSqls()));
        log.debug("consumer sql_performance_lack ==> Parameters:{}", JsonUtils.toJson(sqlMessage.getArgs()));

        try {
            Boolean rstBatchSqls = baseDao.batchSqls(sqlMessage.getSqls(), sqlMessage.getArgs());
            log.debug("CONSUMER_PERFORMANCE_LACK result of execution:{}", rstBatchSqls);
            if (rstBatchSqls) {
                channel.basicAck(msg.getMessageProperties().getDeliveryTag(), false);
            } else {
                channel.basicReject(msg.getMessageProperties().getDeliveryTag(), true);
            }
        } catch (Exception e) {
            log.error("error:consumer sql2:{}", JsonUtils.toJson(sqlMessage), e);
            try {
                channel.basicReject(msg.getMessageProperties().getDeliveryTag(), true);
            } catch (IOException ioException) {
                log.error("error:consumer sql2:basicReject.msg.tag:{}", msg.getMessageProperties().getDeliveryTag(), ioException);
            }
        }
    }
}
