package com.liquidnet.service.sweet.handler;

import com.liquidnet.common.third.shumei.util.ShumeiUtil;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.config.WechatMaConfigure;
import com.liquidnet.service.sweet.utils.WechatUsersRedisUtils;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpMessageHandler;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.kefu.WxMpKefuMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutTextMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * <p>
 * 文本消息
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-11-25
 */
@Component
@Slf4j
public class TextMsgHandler implements WxMpMessageHandler {

    @Autowired
    private WechatUsersRedisUtils redisUtils;

    @Autowired
    WechatMaConfigure maConfigure;

    @Autowired
    private ShumeiUtil shumeiUtil;

    @Override
    public WxMpXmlOutMessage handle(WxMpXmlMessage wxMessage, Map<String, Object> context, WxMpService wxMpService,
                                    WxSessionManager sessionManager) throws WxErrorException {
        String openId = wxMessage.getFromUser();
        String content = wxMessage.getContent();

        // 2021草莓音乐节海报活动
        if (StringUtil.trim(content).equals("白日梦")) {
            redisUtils.setStrawberryPosterClick(wxMessage.getFromUser(), 10 * 60);

            return WxMpXmlOutMessage.TEXT().content("你梦中的草莓音乐节会有怎样的阵容？\n" +
                            "不如做一次白日梦，挑选你心水的草莓阵容！\n" +
                            "参与活动之前，请先告诉我你的昵称！（直接在对话框输入即可\uD83D\uDC47，9个字以内）")
                    .fromUser(wxMessage.getToUser()).toUser(wxMessage.getFromUser())
                    .build();
        } else if (redisUtils.getStrawberryPosterClick(openId)) {
            // 验证
            if (content.length() > 9) {
                return WxMpXmlOutMessage.TEXT().content("昵称要9个字以内～")
                        .fromUser(wxMessage.getToUser()).toUser(openId)
                        .build();
            }
            if (!shumeiUtil.checkText(openId, content)) {
                return WxMpXmlOutMessage.TEXT().content("无法识别，换个昵称吧！（请勿使用表情等特殊字符）")
                        .fromUser(wxMessage.getToUser()).toUser(openId)
                        .build();
            }

            // 发送文本消息
            WxMpXmlOutTextMessage build = WxMpXmlOutMessage.TEXT().content("你好，".concat(content).concat("！点击下方小程序卡片开始搭建你梦想的草莓音乐节阵容！"))
                    .fromUser(wxMessage.getToUser()).toUser(openId)
                    .build();
            // 发送活动小程序卡片
            WxMpKefuMessage message = WxMpKefuMessage.MINIPROGRAMPAGE()
                    .appId(maConfigure.getWxMaAppid(4))
                    .pagePath("/pages/index?nickname=".concat(content))
                    .thumbMediaId("ov08q51In7bXX6tXv7FewxFNN0G78n-pPRsbi3LZbPE")
                    .title("做一场白日梦，挑选你心水的草莓阵容！")
                    .toUser(openId)
                    .build();
            wxMpService.getKefuService().sendKefuMessage(message);
            return build;
        }


        return null;
    }
}
