package com.liquidnet.client.admin.web.controller.zhengzai.kylin;

import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.zhengzai.kylin.service.impl.KylinPerformancesAdminServiceImpl;
import com.liquidnet.client.admin.zhengzai.kylin.service.impl.KylinRefundPerformancesAdminServiceImpl;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dao.OrderRefundBatchDao;
import com.liquidnet.service.kylin.dao.PerformanceOrderStatisticalDao;
import com.liquidnet.service.kylin.dto.param.RefundBatchApplyParam;
import com.liquidnet.service.kylin.dto.param.RefundBatchSearchParam;
import com.liquidnet.service.kylin.dto.vo.KylinOrderRefundBatchesPerformanceVo;
import com.liquidnet.service.kylin.dto.vo.KylinOrderRefundBatchesVo;
import com.liquidnet.service.kylin.dto.vo.partner.KylinPerformanceMisVo;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 后台按演出批量退款 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-25 11:07 上午
 */

@Controller
@RequestMapping("/kylin/refundBatch")
public class KylinOrderRefundBatchAdminController extends BaseController {

    private String prefix = "zhengzai/kylin/refundBatch";

    @Autowired
    private KylinRefundPerformancesAdminServiceImpl kylinRefundPerformancesAdminServiceImpl;

    @Autowired
    private KylinPerformancesAdminServiceImpl kylinPerformancesService;

    @RequiresPermissions("kylin:refundBatch:view")
    @GetMapping()
    public String operlog()
    {
        return prefix + "/refundBatch";
    }

    @RequiresPermissions("kylin:refundBatch:detail")
    @GetMapping(value = "/details/{refundBatchId}")
    public String detail(@PathVariable("refundBatchId") String refundBatchId, ModelMap mmap) {
        KylinOrderRefundBatchesVo result = null;
        result = kylinRefundPerformancesAdminServiceImpl.detail(refundBatchId);
        mmap.put("KylinOrderRefundsBatchVo", result);
        return prefix + "/details";
    }

    @RequiresPermissions("kylin:refundBatch:list")
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo refundList(RefundBatchSearchParam refundBatchSearchParam) {
        PageInfo<OrderRefundBatchDao> result = kylinRefundPerformancesAdminServiceImpl.refundList(refundBatchSearchParam);
        return getDataTable(result.getList());
    }

    @GetMapping("applyView")
    public String applyView() {
        return prefix +  "/applyView";
    }

    @PostMapping("applyPerformance")
    @ResponseBody
    public KylinOrderRefundBatchesPerformanceVo applyPerformance(RefundBatchApplyParam refundBatchApplyParam) {
        String performancesId = refundBatchApplyParam.getTargetId();
        //获取演出详情
        KylinPerformanceMisVo performanceMisVo = kylinPerformancesService.performanceDetails(performancesId);

        List<PerformanceOrderStatisticalDao> result = kylinPerformancesService.getPerformanceOrderStatisticalList(performancesId);
        KylinOrderRefundBatchesPerformanceVo kylinOrderRefundBatchesPerformanceVo = new KylinOrderRefundBatchesPerformanceVo();
        kylinOrderRefundBatchesPerformanceVo.setKylinPerformanceMisVo(performanceMisVo);
        kylinOrderRefundBatchesPerformanceVo.setPerformanceOrderStatisticalDao(result);
        return kylinOrderRefundBatchesPerformanceVo;
    }

    @RequiresPermissions("kylin:refundBatch:apply")
    @PostMapping("apply")
    @ResponseBody
    public AjaxResult refundBatchApply(RefundBatchApplyParam refundBatchApplyParam) {
        try {
            Boolean res = kylinRefundPerformancesAdminServiceImpl.refundBatchApply(refundBatchApplyParam);
            if (res) {
                return success();
            } else {
                return error("申请退款失败");
            }
        } catch (Exception e) {
            e.printStackTrace();
            return error(e.getMessage());
        }
    }

    @RequiresPermissions("kylin:refundBatch:reapply")
    @PostMapping("reapply")
    @ResponseBody
    public AjaxResult refundBatchReApply(RefundBatchApplyParam refundBatchApplyParam) {
        String ids = refundBatchApplyParam.getIds();
        refundBatchApplyParam.setRefundBatchId(ids);
        refundBatchApplyParam.setType("reapply");
        try {
            ResponseDto res = kylinRefundPerformancesAdminServiceImpl.refundBatchCheckStatus(refundBatchApplyParam);
            if (res.isSuccess()) {
                return success();
            } else {
                return error(res.getMessage());
            }
        } catch (Exception e) {
            return error(e.getMessage());
        }
    }

    @RequiresPermissions("kylin:refundBatch:cancel")
    @PostMapping("cancel")
    @ResponseBody
    public AjaxResult refundBatchCancel(RefundBatchApplyParam refundBatchApplyParam) {
        String ids = refundBatchApplyParam.getIds();
        refundBatchApplyParam.setRefundBatchId(ids);
        refundBatchApplyParam.setType("cancel");
        try {
            ResponseDto res = kylinRefundPerformancesAdminServiceImpl.refundBatchCheckStatus(refundBatchApplyParam);
            if (res.isSuccess()) {
                return success();
            } else {
                return error(res.getMessage());
            }
        } catch (Exception e) {
            return error(e.getMessage());
        }
    }

    @RequiresPermissions("kylin:refundBatch:review")
    @PostMapping("review")
    @ResponseBody
    public AjaxResult refundBatchReview(RefundBatchApplyParam refundBatchApplyParam) {
        refundBatchApplyParam.setType("review");
        try {
            ResponseDto res = kylinRefundPerformancesAdminServiceImpl.refundBatchCheckStatus(refundBatchApplyParam);
            if (res.isSuccess()) {
                return success();
            } else {
                return error(res.getMessage());
            }
        } catch (Exception e) {
            return error(e.getMessage());
        }
    }

    @RequiresPermissions("kylin:refundBatch:execute")
    @PostMapping("execute")
    @ResponseBody
    public AjaxResult refundBatchExecute(RefundBatchApplyParam refundBatchApplyParam) {
        refundBatchApplyParam.setType("execute");
        try {
            ResponseDto res = kylinRefundPerformancesAdminServiceImpl.refundBatchCheckStatus(refundBatchApplyParam);
            if (res.isSuccess()) {
                return success();
            } else {
                return error(res.getMessage());
            }
        } catch (Exception e) {
            e.printStackTrace();
            return error(e.getMessage());
        }
    }

}
