package com.liquidnet.client.admin.web.controller.zhengzai.kylin;

import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.utils.ShiroUtils;
import com.liquidnet.client.admin.common.utils.poi.ExcelUtil;
import com.liquidnet.client.admin.zhengzai.kylin.dto.OrderOutLineVo;
import com.liquidnet.client.admin.zhengzai.kylin.service.IImportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

@Controller
@RequestMapping("/import")
public class ImportController {

    @Autowired
    IImportService iImportService;

    /**
     * 下载模板
     */
    @GetMapping("/template/OrderOutLine")
    @ResponseBody
    public AjaxResult importTemplateOrderOutLine() {
        ExcelUtil<OrderOutLineVo> util = new ExcelUtil(OrderOutLineVo.class);
        return util.importTemplateExcel("订单导入数据");
    }


    /**
     * 导入
     */
    @PostMapping("/OrderOutLine/{performancesId}")
    @ResponseBody
    public AjaxResult importOrderOutLine(@PathVariable("performancesId") String performancesId, MultipartFile file, boolean updateSupport) throws Exception {
        ExcelUtil<OrderOutLineVo> util = new ExcelUtil(OrderOutLineVo.class);
        List<OrderOutLineVo> orderOutLineVoList = util.importExcel(file.getInputStream());
//        String operName = ShiroUtils.getSysUser().getLoginName();
        String message = iImportService.importOrderOutLine(performancesId, orderOutLineVoList, updateSupport, file.getName());
        return AjaxResult.success(message);
    }


}
