package com.liquidnet.service.galaxy.router.xuper.biz;

import com.baidu.xuper.api.Account;
import com.liquidnet.common.third.xuper.dto.Xuper000CreateAccountReqDto;
import com.liquidnet.common.third.xuper.dto.Xuper000CreateAccountRespDto;
import com.liquidnet.common.third.xuper.dto.XuperResponseDto;
import com.liquidnet.common.third.xuper.exception.XupterException;
import com.liquidnet.common.third.xuper.util.XuperSdkUtil;
import com.liquidnet.common.third.zxlnft.constant.ZxlErrorEnum;
import com.liquidnet.common.third.zxlnft.exception.ZxlNftException;
import com.liquidnet.commons.lang.util.*;
import com.liquidnet.service.adam.constant.AdamEnum;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.galaxy.constant.GalaxyConstant;
import com.liquidnet.service.galaxy.constant.GalaxyEnum;
import com.liquidnet.service.galaxy.dto.bo.GalaxyUserInfoBo;
import com.liquidnet.service.galaxy.dto.param.GalaxyUserRegisterReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyUserRegisterRespDto;
import com.liquidnet.service.galaxy.exception.GalaxyNftUserException;
import com.liquidnet.service.galaxy.utils.GalaxyDataUtils;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.constant.NftAccStatusEnum;
import com.liquidnet.service.goblin.dto.GoblinUserNftAccInfoVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ZxinUserCommonBiz
 * @Package com.liquidnet.service.galaxy.router.zxin.biz
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/6/27 13:08
 */
@Slf4j
@Component
public class XuperUserCommonBiz {
    @Autowired
    private XuperSdkUtil xuperSdkUtil;

    @Autowired
    private GalaxyDataUtils dataUtils;

    @Value("${liquidnet.service.adam.url}")
    private String adamUrl;

    public ResponseDto<GalaxyUserRegisterRespDto> userRegister(GalaxyUserRegisterReqDto reqDto) {
        long startTime = System.currentTimeMillis();
        String userId = reqDto.getUserId();
        String userName = reqDto.getUserName();
        String mobile = reqDto.getMobile();
        String idCardType = reqDto.getIdCardType();
        String idCard = reqDto.getIdCard();
        String mnemonic = null;
        Long index = 0L;
        String userIdentification = null;
        String address = null;
        String userPubKey = null;
        String userPriKey = null;

        //业务失败信息
        String bizFailDesc = null;
        //系统失败信息
        String sysFailDesc = null;
        //是否实名认证成功
        boolean isRealNameAuthSuccess = true;
        //是否绑定区块链地址
        boolean isBindBlockAddressSuccess = false;
        GalaxyUserRegisterRespDto respDto = GalaxyUserRegisterRespDto.getNew();

        //用户信息
        GalaxyUserInfoBo userInfoBo = null;
        try{
            /**
             * todo 把助记词进行redis存储  key=userID  mnemonic/index/userIdentification/address
             */
            userInfoBo = dataUtils.getGalaxyUserInfo(reqDto.getRouterType(),userId);
            if(userInfoBo!=null){
                mnemonic = userInfoBo.getMnemonic();

                if(StringUtil.isNotEmpty(userInfoBo.getBlockChainAddress())){
                    try{
                        //同步用户数字账户开通信息
                        boolean isOpenAccount = syncOpenAccount(reqDto,respDto.getBlockChainAddress(),bizFailDesc,sysFailDesc,true,true);
                        log.info("用户 {} 数字账户开通结果:{}",reqDto.getUserId(),isOpenAccount);
                    }catch(Exception e){
                        log.error("同步用户数字账户开通信息异常："+e.getMessage(),e);
                    }
                    return ResponseDto.failure("已经开通过数字账户");
                }
            }else{
                Xuper000CreateAccountReqDto xuper000CreateAccountReqDto = Xuper000CreateAccountReqDto.getNew();
                // 创建区块链账户
                Xuper000CreateAccountRespDto xuper000CreateAccountRespDto = null;
                try {
                    XuperResponseDto<Xuper000CreateAccountRespDto> xuperResponseDto = xuperSdkUtil.xuper000CreateAccount(xuper000CreateAccountReqDto);
                    if(xuperResponseDto.isSuccess()){
                        xuper000CreateAccountRespDto = xuperResponseDto.getParseData(Xuper000CreateAccountRespDto.class);
                    }
                }catch (XupterException e) {
                    log.error("biz error msg "+e.getMessage(),e);
                }catch (Exception e) {
                    log.error("sys error msg "+e.getMessage(),e);
                }
                log.info("testXuper000CreateAccount resp : "+ JsonUtils.toJson(xuper000CreateAccountRespDto));
                mnemonic = xuper000CreateAccountRespDto.getMnemonic();
            }
            if(StringUtil.isNotEmpty(mnemonic)){
                Account account = xuperSdkUtil.getAccount(mnemonic);
                userPubKey = BASE64Util.encoded(account.getKeyPair().getJSONPublicKey());
                userPriKey = BASE64Util.encoded(account.getKeyPair().getJSONPrivateKey());
                userIdentification = account.getAddress();
                address = account.getAddress();
            }

            if(StringUtil.isNull(userInfoBo)){
                //初始化用户信息
                try{
                    //构造缓存数据
                    userInfoBo = GalaxyUserInfoBo.getNew();
                    userInfoBo.setUserId(userId);
                    userInfoBo.setUserName(userName);
                    userInfoBo.setMobile(mobile);
                    userInfoBo.setIdCardType(idCardType);
                    userInfoBo.setIdCard(idCard);
                    userInfoBo.setMnemonic(mnemonic);
                    userInfoBo.setIndex(index.toString());
                    userInfoBo.setUserIdentification(userIdentification);
                    userInfoBo.setUserPubKey(userPubKey);
                    userInfoBo.setUserPriKey(userPriKey);
                    userInfoBo.setRouterType(GalaxyEnum.RouterTypeEnum.ZXINCHAIN.getCode());
                    userInfoBo.setBlockChainAddress(address);
                    dataUtils.setGalaxyUserInfo(reqDto.getRouterType(),reqDto.getUserId(),userInfoBo);
                }catch(Exception e){
                    log.error("设置用户信息异常 msg：{}",e.getMessage(),e);
                    throw new ZxlNftException(ZxlErrorEnum.FAILURE.getCode(),"设置用户信息异常");
                }
            }
        }catch (GalaxyNftUserException e) {
            bizFailDesc = e.getMessage();
            log.info(e.getMessage());
        }catch(ZxlNftException e){
            sysFailDesc = e.getMessage();
            log.error(e.getMessage(),e);
        }catch(Exception e){
            sysFailDesc = e.getMessage();
            log.error(e.getMessage(),e);
        }

        //如果实名认证成功-更新数据库
        if(isRealNameAuthSuccess){
            if(StringUtil.isNotNull(userInfoBo)){
                userInfoBo.setUserName(userName);
                userInfoBo.setMobile(mobile);
                userInfoBo.setIdCardType(idCardType);
                userInfoBo.setIdCard(idCard);
                userInfoBo.setUserIdentification(userIdentification);
                dataUtils.updateGalaxyUserInfo(reqDto.getRouterType(),reqDto.getUserId(),userInfoBo);
            }
        }

        try{
            //同步用户数字账户开通信息
            boolean isOpenAccount = syncOpenAccount(reqDto,respDto.getBlockChainAddress(),bizFailDesc,sysFailDesc,isRealNameAuthSuccess,isBindBlockAddressSuccess);
            log.info("用户 {} 数字账户开通结果:{}",reqDto.getUserId(),isOpenAccount);
        }catch(Exception e){
            log.error("同步用户数字账户开通信息异常："+e.getMessage(),e);
        }

        long endTime = System.currentTimeMillis();
        log.info("开通数字账户userRegister总耗时:{} ",endTime-startTime);

        if(StringUtil.isNotEmpty(sysFailDesc)){
            return ResponseDto.failure(sysFailDesc);
        }
        if(StringUtil.isNotEmpty(bizFailDesc)){
            return ResponseDto.failure(bizFailDesc);
        }
        return ResponseDto.success(respDto);
    }

    /**
     * 同步用户数字账户开通信息
     * @param reqDto
     * @param bizFailDesc
     * @param sysFailDesc
     * @param isRealNameAuthSuccess
     * @param isBindBlockAddressSuccess
     * @return
     */
    private boolean syncOpenAccount(GalaxyUserRegisterReqDto reqDto,String blockChainAddress,String bizFailDesc,String sysFailDesc,
                                   boolean isRealNameAuthSuccess,boolean isBindBlockAddressSuccess){
        long startTime = System.currentTimeMillis();
        long openAccSuccessKeyExpireTime = 3600*24*30*3;
        long openAccFailKeyExpireTime = 60*5;

        //是否开通数字账户
        boolean isOpenAccount = false;
        //开通失败错误信息
        String resultCode = NftAccStatusEnum.StatusAcc.ING.getCode();
        String resultMessage = NftAccStatusEnum.StatusAcc.ING.getMsg();

        //实名成功+绑定区块链地址成功
        if(isRealNameAuthSuccess && isBindBlockAddressSuccess){
            isOpenAccount = true;
            resultCode = NftAccStatusEnum.StatusAcc.SUCCESS.getCode();
            resultMessage = NftAccStatusEnum.StatusAcc.SUCCESS.getMsg();
        }

        //开通数字账户失败
        if(!isOpenAccount){
            //实名失败
            if(!isRealNameAuthSuccess){
                if(StringUtil.isNotEmpty(bizFailDesc)){
                    resultCode = NftAccStatusEnum.StatusAcc.FAILURE1.getCode();
                    resultMessage = NftAccStatusEnum.StatusAcc.FAILURE1.getMsg();
                }else if(StringUtil.isNotEmpty(sysFailDesc)){
                    resultCode = NftAccStatusEnum.StatusAcc.FAILURE2.getCode();
                    resultMessage = NftAccStatusEnum.StatusAcc.FAILURE2.getMsg();
                }
            }else{
                //地址绑定失败
                if(!isBindBlockAddressSuccess){
                    if(StringUtil.isNotEmpty(bizFailDesc)){
                        resultCode = NftAccStatusEnum.StatusAcc.FAILURE3.getCode();
                        resultMessage = NftAccStatusEnum.StatusAcc.FAILURE3.getMsg();
                    }else if(StringUtil.isNotEmpty(sysFailDesc)){
                        resultCode = NftAccStatusEnum.StatusAcc.FAILURE2.getCode();
                        resultMessage = NftAccStatusEnum.StatusAcc.FAILURE2.getMsg();
                    }
                }
            }
        }

        //更新至信链开户状态
        GoblinUserNftAccInfoVo goblinUserNftAccInfoVo = GoblinUserNftAccInfoVo.getNew();
        goblinUserNftAccInfoVo.setCode(resultCode);
        goblinUserNftAccInfoVo.setMsg(resultMessage);
        goblinUserNftAccInfoVo.setTime(LocalDateTime.now());

        if(isOpenAccount){
            //更新开户状态
            dataUtils.getRedisUtil().set(GoblinRedisConst.REDIS_GOBLIN_NFT_NUM_ACCOUNT_INFO.concat(reqDto.getUserId())
                    ,goblinUserNftAccInfoVo);

            //同步用户信息到adam 格式：{uid},{mobile},{证件类型}{证件号},{姓名}
            syncUserAccountInfoToAdam(reqDto);

            //同步业务账号关联关系到adam
            dataUtils.getQueueUtil().sendMsgByRedis(MQConst.GoblinQueue.SQL_STORE.getKey(),
                    SqlMapping.get("adam_user_busi_acct.add", reqDto.getUserId(), AdamEnum.BizAcct.NFT_ZX.name(), blockChainAddress, null, null, 1, LocalDateTime.now())
            );

            //开户成功记录缓存 {goblin:nft:certmeta:{idType+idNo},{idname,mobile}}
            dataUtils.getRedisUtil().set(GoblinRedisConst.REDIS_GOBLIN_NFT_CERTMETA.concat(reqDto.getIdCardType().concat(reqDto.getIdCard()))
                    ,reqDto.getUserName().concat(",").concat(reqDto.getMobile()),openAccSuccessKeyExpireTime);
        }else{
            //更新开户状态
            dataUtils.getRedisUtil().set(GoblinRedisConst.REDIS_GOBLIN_NFT_NUM_ACCOUNT_INFO.concat(reqDto.getUserId())
                    ,goblinUserNftAccInfoVo);
        }

        //设置错误信息到redis
        if(StringUtil.isNotEmpty(resultCode)&&resultCode.equalsIgnoreCase(NftAccStatusEnum.StatusAcc.FAILURE1.getCode())){
            //开户失败记录缓存 {goblin:nft:certmeta:{idType+idNo},{idname,mobile}}
            dataUtils.getRedisUtil().set(GoblinRedisConst.REDIS_GOBLIN_NFT_CERTMETA_JUNK.concat(reqDto.getIdCardType().concat(reqDto.getIdCard()))
                    ,reqDto.getUserName().concat(",").concat(reqDto.getMobile()),openAccFailKeyExpireTime);
        }
        long endTime = System.currentTimeMillis();
        log.info("同步数字账户syncOpenAccount总耗时:{} ",endTime-startTime);
        return isOpenAccount;
    }

    /**
     * 同步用户信息到adam 格式：{uid},{mobile},{证件类型}{证件号},{姓名}
     * @param reqDto
     * @return
     */
    private boolean syncUserAccountInfoToAdam(GalaxyUserRegisterReqDto reqDto) {
        try {
            String certmetaInfo = reqDto.getUserId().concat(",")
                          .concat(reqDto.getMobile()).concat(",")
                          .concat(reqDto.getIdCardType().concat(reqDto.getIdCard())).concat(",")
                          .concat(reqDto.getUserName());
            //加密用户信息
            DESUtils desUtils = DESUtils.DES();
//            MultiValueMap<String, String> params = new LinkedMultiValueMap();
//            params.add("certmeta",desUtils.encrypt(certmetaInfo));
//
//            HttpUtil.post(adamUrl + GalaxyConstant.ADAM_USER_SYNC_URL, params);
            HttpUtil.postJson(adamUrl + GalaxyConstant.ADAM_USER_SYNC_URL, desUtils.encrypt(certmetaInfo));
        } catch (Exception e) {
            log.error("同步用户信息到adam异常:{}",JsonUtils.toJson(reqDto), e);
            return false;
        }
        return true;
    }
}
