package com.liquidnet.service.galaxy.router.xuper.biz;

import com.baidu.xuper.crypto.Hash;
import com.liquidnet.common.third.xuper.config.XuperConfig;
import com.liquidnet.common.third.xuper.constant.XuperEnum;
import com.liquidnet.common.third.xuper.dto.*;
import com.liquidnet.common.third.xuper.exception.XupterException;
import com.liquidnet.common.third.xuper.util.XuperSdkUtil;
import com.liquidnet.common.third.zxlnft.biz.ZxlnftBiz;
import com.liquidnet.common.third.zxlnft.constant.ZxlnftEnum;
import com.liquidnet.common.third.zxlnft.exception.ZxlNftException;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.biz.GalaxyCommonBiz;
import com.liquidnet.service.galaxy.biz.GalaxyEnumBiz;
import com.liquidnet.service.galaxy.constant.GalaxyConstant;
import com.liquidnet.service.galaxy.constant.GalaxyEnum;
import com.liquidnet.service.galaxy.constant.GalaxyErrorEnum;
import com.liquidnet.service.galaxy.dto.bo.GalaxySeriesInfoBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxySeriesNftInfoBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxySeriesNftUploadBo;
import com.liquidnet.service.galaxy.dto.param.*;
import com.liquidnet.service.galaxy.utils.GalaxyDataUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 百度超级链艺术品上传
 * @class: XuperArtworkBiz
 * @Package com.liquidnet.service.galaxy.router.xuper.biz
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/6/27 11:10
 */
@Slf4j
@Component
public class XuperArtworkBiz {
    @Autowired
    private ZxlnftBiz zxlnftBiz;

    @Autowired
    private XuperSdkUtil xuperSdkUtil;

    @Autowired
    private XuperConfig xuperConfig;

    @Autowired
    private GalaxyDataUtils dataUtils;

    @Autowired
    private GalaxyCommonBiz galaxyCommonBiz;


    public ResponseDto<GalaxyNftImageRespDto> nftImageCheck(GalaxyNftImageReqDto reqDto) {
        GalaxyNftImageRespDto nftImageRespDto = GalaxyNftImageRespDto.getNew();
        nftImageRespDto.setSuggestion("Pass");
        nftImageRespDto.setLabel("Normal");
        nftImageRespDto.setScore(100);
        return ResponseDto.success(nftImageRespDto);
    }



    public ResponseDto<GalaxyNftUploadRespDto> nftUpload(GalaxyNftUploadReqDto reqDto) {
        /**
         * 系列缓存初始化
         */

        //获取任务ID
        GalaxySeriesNftUploadBo seriesNftUploadBo = dataUtils.getSeriesNftUploadBo(reqDto.getRouterType(),reqDto.getSkuId());
        if(StringUtil.isNotNull(seriesNftUploadBo)){
            return ResponseDto.failure("素材已经上传过！");
        }

        String originalNftUrl = reqDto.getOriginalNftUrl();
        String originalDisplayUrl = reqDto.getOriginalDisplayUrl();
        //上传系列名只用来目录区分
        String seriesName = GalaxyConstant.SERIES_NAME_PREFIX + reqDto.getSkuId(); //素材存储目录

        //返回素材上传结果
        GalaxyNftUploadRespDto galaxyNftUploadRespDto = GalaxyNftUploadRespDto.getNew();
        try {
            galaxyNftUploadRespDto.setSkuId(reqDto.getSkuId());
            galaxyNftUploadRespDto.setNftUrl(this.getFullFilePath(seriesName,originalNftUrl));
            galaxyNftUploadRespDto.setOriginalNftUrl(reqDto.getOriginalNftUrl());
            galaxyNftUploadRespDto.setDisplayUrl(this.getFullFilePath(seriesName,originalDisplayUrl));
            galaxyNftUploadRespDto.setOriginalDisplayUrl(reqDto.getOriginalDisplayUrl());
        } catch(ZxlNftException e){
            log.error(e.getMessage());
            return ResponseDto.failure(e.getCode(),e.getMessage());
        }catch (Exception e) {
            log.error(e.getMessage());
            return ResponseDto.failure(e.getMessage());
        }

        seriesNftUploadBo = GalaxySeriesNftUploadBo.getNew();
        seriesNftUploadBo.setSkuId(reqDto.getSkuId());
        seriesNftUploadBo.setOriginalNftUrl(originalNftUrl);
        seriesNftUploadBo.setOriginalDisplayUrl(originalDisplayUrl);
        seriesNftUploadBo.setNftUrl(galaxyNftUploadRespDto.getNftUrl());
        seriesNftUploadBo.setDisplayUrl(galaxyNftUploadRespDto.getDisplayUrl());
        dataUtils.setSeriesNftUploadBo(reqDto.getRouterType(),reqDto.getSkuId(),seriesNftUploadBo);

        return ResponseDto.success(galaxyNftUploadRespDto);
    }

    public ResponseDto<GalaxyArtSeriesClaimRespDto> seriesClaim(GalaxyArtSeriesClaimReqDto reqDto) {
        //系列声明用到参数
        String skuId = reqDto.getSkuId();
        //以下系列名称可以用spu名称代替
        String seriesName = GalaxyConstant.SERIES_NAME_PREFIX.concat(skuId);
        String seriesCode = GalaxyConstant.SERIES_NAME_PREFIX.concat(skuId);

        Long totalCount = reqDto.getTotalCount();
        String coverUrl = reqDto.getCoverUrl();//暂时用nftUrl
        String seriesDesc = reqDto.getSeriesDesc();

        //根据skuId获取原始上传信息
        GalaxySeriesNftUploadBo seriesNftUploadBo = dataUtils.getSeriesNftUploadBo(reqDto.getRouterType(),reqDto.getSkuId());
        if(StringUtil.isNull(seriesNftUploadBo)){
            return ResponseDto.failure(GalaxyErrorEnum.SERIES_CLAIM_NOT_EXIST.getCode(),GalaxyErrorEnum.SERIES_CLAIM_NOT_EXIST.getMessage());
        }

        //目前一个系列上传一个nft
        GalaxySeriesInfoBo seriesInfoBo = dataUtils.getSeriesInfoBo(reqDto.getRouterType(),seriesCode);
        if(StringUtil.isNotNull(seriesInfoBo)){
            /**
             * 如果系列声明成功，则不允许继续声明
             */
            if(seriesInfoBo.getSeriesClaimStatus().equalsIgnoreCase(GalaxyEnum.SeriesClaimStatusEnum.PROCESSING.getCode())){
                return ResponseDto.failure(GalaxyErrorEnum.SERIES_CLAIM_PROCESSING.getCode(),GalaxyErrorEnum.SERIES_CLAIM_PROCESSING.getMessage());
            }else if(seriesInfoBo.getSeriesClaimStatus().equalsIgnoreCase(GalaxyEnum.SeriesClaimStatusEnum.SUCCESS.getCode())){
                return ResponseDto.failure(GalaxyErrorEnum.SERIES_CLAIM_SUCCESSED.getCode(),GalaxyErrorEnum.SERIES_CLAIM_SUCCESSED.getMessage());
            }
        }


        //业务失败信息
        String bizFailDesc = null;
        //系统失败信息
        String sysFailDesc = null;
        GalaxyArtSeriesClaimRespDto seriesClaimRespDto = null;
        // 创建区块链数字资产
        Xuper002CreateAssetRespDto xuper002CreateAssetRespDto = null;
        try {
            Xuper002CreateAssetReqDto xuper002CreateAssetReqDto = Xuper002CreateAssetReqDto.getNew();

            String nftUrl = "bos_v1://xasset-offline/110381/ZXLNFTIMAGE202206231042217867523750.jpg/";
            try {
                xuper002CreateAssetReqDto.setMnemonic(xuperConfig.getNftPlatformMnemonic());
                //资产碎片数量，小于1和大于200000代表不做库存限制
                xuper002CreateAssetReqDto.setAmount(100);
                //藏品显示售卖价格，单位为分
                xuper002CreateAssetReqDto.setPrice(1000l);
                //资产分类。1：艺术品 2：收藏品 3：门票 4：酒店
                xuper002CreateAssetReqDto.setAssetCate(Integer.valueOf(XuperEnum.assetTypeEnum.COLLECTION.getCode()));
                //资产名称，小于30个字节
                xuper002CreateAssetReqDto.setTitle("百度超级链-数字藏品-测试20220622-001");
                //资产缩略图。bos上传的图片，格式支持：”jpg”, “jpeg”, “png”, “bmp”, “webp”, “heic”。参数格式bos_v1://{bucket}/{object}/{width}_{height}
                xuper002CreateAssetReqDto.setThumb(nftUrl.concat("1000_500"));
                //短文字描述，小于300个字节
                xuper002CreateAssetReqDto.setShortDesc(xuper002CreateAssetReqDto.getTitle().concat("-短文字描述小于300个字节"));
                //(可选)资产详情介绍长图。bos上传的图片，格式支持：”jpg”, “jpeg”, “png”, “bmp”, “webp”, “heic”。参数格式bos_v1://{bucket}/{object}/{width}_{height}
                xuper002CreateAssetReqDto.setImgDesc(nftUrl.concat("1000_500"));
                //资产原始文件。比如图片，图片本身就是资产。格式bos_v1://{bucket}/{object} ，文件大小<10M。文件名采用文件md5值，为了正常展现，需要正确携带文件后缀
                xuper002CreateAssetReqDto.setAssetUrl(nftUrl.concat("900_1200"));
                //(可选)长文字描述，小于1200个字节
                xuper002CreateAssetReqDto.setLongDesc(xuper002CreateAssetReqDto.getTitle().concat("-长文字描述，小于1200个字节"));
                //(可选)资产额外描述信息json字符串。比如标签
                xuper002CreateAssetReqDto.setAssetExt("{\"tags\":[\"艺术品\",\"古董\"]} ");
                //(可选)资产组id。用于关联业务层酒店/店铺id
                xuper002CreateAssetReqDto.setGroupId(123123l);
                //(可选)业务侧用户标记，必要时请安全处理后设置
                xuper002CreateAssetReqDto.setUserId(123123l);
                //(可选)要存证的资产文件sm3散列值，如有多个文件逐个计算hash值后合并计算最终hash值
                xuper002CreateAssetReqDto.setFileHash(new String(Hash.doubleSha256(nftUrl.concat("900_1200").getBytes())));
                XuperResponseDto<Xuper002CreateAssetRespDto>  xuperResponseDto = xuperSdkUtil.xuper002CreateAsset(xuper002CreateAssetReqDto);
                if(xuperResponseDto.isSuccess()){
                    xuper002CreateAssetRespDto = xuperResponseDto.getParseData(Xuper002CreateAssetRespDto.class);
                }
            }catch (XupterException e) {
                log.error("biz error msg "+e.getMessage(),e);
            }catch (Exception e) {
                log.error("sys error msg "+e.getMessage(),e);
            }
            log.info("testXuper002CreateAsset resp : "+ JsonUtils.toJson(xuper002CreateAssetRespDto));

            //返回参数
            String seriesId = null;
            String taskId = null;

            seriesClaimRespDto = GalaxyArtSeriesClaimRespDto.getNew();
            if(xuper002CreateAssetRespDto.errNo==0){
                //第零个系列 无限制系列
                taskId = String.valueOf(xuper002CreateAssetRespDto.getAssetId());
                //构造缓存数据
                if(StringUtil.isNull(seriesInfoBo)){
                    //
                    String publishStatus = GalaxyEnum.SeriesClaimStatusEnum.PROCESSING.getCode();
                    //设置系列声明状态
                    seriesClaimRespDto.setSeriesClaimStatus(publishStatus);

                    //构造系列信息
                    seriesInfoBo = this.buildSeriesInfoBo(reqDto,taskId,publishStatus);
                    //等一个系列支持多个藏品后需要从请求参数获取
                    seriesInfoBo.setSeriesName(seriesName);
                    seriesInfoBo.setSeriesCode(seriesCode);
                    dataUtils.setSeriesInfoBo(reqDto.getRouterType(),seriesCode,seriesInfoBo);

                    //构造系列nft信息
                    GalaxySeriesNftInfoBo seriesNftInfoBo = this.buildSeriesNftInfoBo(reqDto,seriesInfoBo,seriesNftUploadBo);
                    dataUtils.setSeriesNftInfoBo(reqDto.getRouterType(),reqDto.getSkuId(),seriesInfoBo,seriesNftInfoBo);

                    if(StringUtil.isEmpty(seriesNftInfoBo.getNftHash())){
                        log.error("生成nftHash error skuId:{} nftUrl is :{} ",seriesNftInfoBo.getSkuId(),seriesNftInfoBo.getNftUrl());
                        throw new ZxlNftException(GalaxyErrorEnum.SERIES_NFT_HASH_CREATE_FAIL.getCode(),GalaxyErrorEnum.SERIES_NFT_HASH_CREATE_FAIL.getMessage());
                    }
                }
            }else{
                return ResponseDto.failure(GalaxyErrorEnum.SERIES_CLAIM_ERROR.getCode(),GalaxyErrorEnum.SERIES_CLAIM_ERROR.getMessage());
            }

            seriesClaimRespDto.setSkuId(skuId);
            seriesClaimRespDto.setNftUrl(seriesNftUploadBo.getNftUrl());
            seriesClaimRespDto.setDisplayUrl(seriesNftUploadBo.getDisplayUrl());
            seriesClaimRespDto.setSeriesId(seriesId);
            seriesClaimRespDto.setSeriesName(seriesName);

        }catch(ZxlNftException e){
            sysFailDesc = e.getMessage();
            log.error(e.getMessage(),e);
        }catch(Exception e){
            sysFailDesc = e.getMessage();
            log.error(e.getMessage(),e);
        }
        if(StringUtil.isNotEmpty(sysFailDesc)){
            return ResponseDto.failure(sysFailDesc);
        }
        if(StringUtil.isNotEmpty(bizFailDesc)){
            return ResponseDto.failure(bizFailDesc);
        }
        return ResponseDto.success(seriesClaimRespDto);
    }

    public ResponseDto<GalaxyArtSeriesClaimResultQueryRespDto> seriesClaimResultQuery(GalaxyArtSeriesClaimResultQueryReqDto reqDto) {
        //根据skuId获取系列nft信息
        GalaxySeriesNftInfoBo seriesNftInfoBo = dataUtils.getSeriesNftInfoBo(reqDto.getRouterType(),reqDto.getSkuId());

        if(StringUtil.isNull(seriesNftInfoBo)){
            return ResponseDto.failure(GalaxyErrorEnum.SERIES_NFT_INFO_NOT_EXIST.getCode(), GalaxyErrorEnum.SERIES_NFT_INFO_NOT_EXIST.getMessage());
        }
        String seriesCode = seriesNftInfoBo.getSeriesCode();

        //如果nftUrl介质hash为空，则重新生成
        if(StringUtil.isEmpty(seriesNftInfoBo.getNftHash())){
            //更新系列对应的系列nft状态
            seriesNftInfoBo.setNftHash(zxlnftBiz.getHashString(seriesNftInfoBo.getNftUrl()));
            dataUtils.updateSeriesNftStatus(reqDto.getRouterType(),reqDto.getSkuId(),seriesNftInfoBo);
        }

        //获取任务ID
        GalaxySeriesInfoBo seriesInfoBo = dataUtils.getSeriesInfoBo(reqDto.getRouterType(),seriesCode);
        if(StringUtil.isNull(seriesInfoBo)||StringUtil.isEmpty(seriesInfoBo.getSeriesClaimTaskId())){
            return ResponseDto.failure(GalaxyErrorEnum.SERIES_NOT_EXIST.getCode(), GalaxyErrorEnum.SERIES_NOT_EXIST.getMessage());
        }
        if(seriesInfoBo.getSeriesClaimStatus().equalsIgnoreCase(GalaxyEnum.SeriesClaimStatusEnum.SUCCESS.getCode())){
            GalaxyArtSeriesClaimResultQueryRespDto resultQueryRespDto = this.buildGalaxyArtSeriesClaimResultQueryRespDto(reqDto,seriesInfoBo,ZxlnftEnum.TaskStatusEnum.TASK_SUCCESS.getCode());
            return  ResponseDto.success(resultQueryRespDto);
        }

        Xuper005QueryAssetReqDto xuper005QueryAssetReqDto = Xuper005QueryAssetReqDto.getNew();
        // 定义返回结果对象
        Xuper005QueryAssetRespDto respDto = null;
        //百度超级链使用的是资产id作为任务id
        long assetId = Long.parseLong(seriesInfoBo.getSeriesClaimTaskId());
        try {
            xuper005QueryAssetReqDto.setAssetId(assetId);
            XuperResponseDto<Xuper005QueryAssetRespDto>  xuperResponseDto = xuperSdkUtil.xuper005QueryAsset(xuper005QueryAssetReqDto);
            if(xuperResponseDto.isSuccess()){
                respDto = xuperResponseDto.getParseData(Xuper005QueryAssetRespDto.class);
            }
        }catch (XupterException e) {
            log.error("biz error msg "+e.getMessage(),e);
        }catch (Exception e) {
            log.error("sys error msg "+e.getMessage(),e);
        }
        log.info("seriesClaimResultQuery resp : "+ JsonUtils.toJson(respDto));
        if(respDto.getErrNo() == 0){
            if(respDto.getMeta().getStatus() == Integer.parseInt(XuperEnum.AssetStatusEnum.INIT.getCode())
            || respDto.getMeta().getStatus() == Integer.parseInt(XuperEnum.AssetStatusEnum.PUBLISH_SUCCESS.getCode())){
                //设置系列声明状态
                seriesInfoBo.setSeriesClaimStatus(GalaxyEnum.SeriesClaimStatusEnum.SUCCESS.getCode());
                String nowTimeStr = DateUtil.getNowTime();
                seriesInfoBo.setChainTimestamp(nowTimeStr);
                seriesInfoBo.setTradeHash(respDto.getMeta().getTxId());
                seriesInfoBo.setSeriesId(String.valueOf(respDto.getMeta().getAssetId()));
                seriesInfoBo.setUpdatedAt(LocalDateTime.now());

                //根据系列编号更新系列声明状态 1对多skuId
//                dataUtils.updateSeriesClaimStatus(reqDto.getRouterType(),seriesCode,seriesInfoBo);

                //根据skuId更新系列声明状态 1对1
                dataUtils.updateSeriesClaimStatus(reqDto.getRouterType(),seriesCode,seriesInfoBo,reqDto.getSkuId());

                //设置成功返回参数
                GalaxyArtSeriesClaimResultQueryRespDto resultQueryRespDto = this.buildGalaxyArtSeriesClaimResultQueryRespDto(reqDto,seriesInfoBo,ZxlnftEnum.TaskStatusEnum.TASK_SUCCESS.getCode());

                return ResponseDto.success(resultQueryRespDto);
            }else if(respDto.getMeta().getStatus() != Integer.parseInt(XuperEnum.AssetStatusEnum.INIT.getCode())
                    && respDto.getMeta().getStatus() != Integer.parseInt(XuperEnum.AssetStatusEnum.PUBLISH_SUCCESS.getCode())){
                seriesInfoBo.setSeriesClaimStatus(GalaxyEnum.SeriesClaimStatusEnum.FAIL.getCode());
                seriesInfoBo.setUpdatedAt(LocalDateTime.now());

                //根据系列编号更新系列声明状态 1对多skuId
//                dataUtils.updateSeriesClaimStatus(reqDto.getRouterType(),seriesCode,seriesInfoBo);
                //根据skuId更新系列声明状态 1对1
                dataUtils.updateSeriesClaimStatus(reqDto.getRouterType(),seriesCode,seriesInfoBo,reqDto.getSkuId());



                return ResponseDto.failure(GalaxyErrorEnum.SERIES_CLAIM_ERROR.getCode(), GalaxyErrorEnum.SERIES_CLAIM_ERROR.getMessage());
            }
        }
        return ResponseDto.failure(GalaxyErrorEnum.SERIES_CLAIM_ERROR.getCode(), GalaxyErrorEnum.SERIES_CLAIM_ERROR.getMessage());
    }

    private String getFullFilePath(String seriesName,String originalUrl){
        //完整全路径 https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/NOW_ZXL_NFT_PIC001_test_skuId001/2022-03-04/ZXLNFTIMAGE202203041707466694345291.jpg
        String fullFilePath = null; //需要保存,返回给调用者
        // 创建区块链账户
        XuperUploadFileRespDto respDto = null;
        try {
            String filePath = null;
            String imageType = null;

            if(originalUrl.lastIndexOf("?")!=-1){
                String tempUrl = originalUrl.substring(0,originalUrl.lastIndexOf("?"));
                imageType = tempUrl.substring(tempUrl.lastIndexOf("."),tempUrl.length());
            }else{
                imageType = originalUrl.substring(originalUrl.lastIndexOf("."),originalUrl.length());
            }
            String fileName =  IDGenerator.getZxlNftImageCosCode() + imageType;

            //通过图片url地址上传
            File cosFile = galaxyCommonBiz.inputStreamToFile(originalUrl,fileName);
            filePath = cosFile.getAbsolutePath();
            log.info("cosFile.getPath() :{}",cosFile.getPath());
            log.info("cosFile.getAbsoluteFile() :{}",cosFile.getAbsoluteFile());

            XuperUploadFileReqDto reqDto = XuperUploadFileReqDto.getNew();

            reqDto.setMnemonic(xuperConfig.getNftPlatformMnemonic());
            reqDto.setFileName(fileName);
            reqDto.setFilePath(filePath);

            byte[] fileByte = new byte[0];
            try {
                fileByte = galaxyCommonBiz.toByteArray(new File(filePath));
            } catch (IOException e) {
                e.printStackTrace();
            }
            reqDto.setDataByte(fileByte);
            reqDto.setProperty("");
            XuperResponseDto<XuperUploadFileRespDto> uploadFileResp = xuperSdkUtil.xuperUploadFile(reqDto);
            if(uploadFileResp.isSuccess()){
                respDto = uploadFileResp.getParseData(XuperUploadFileRespDto.class);
                fullFilePath = respDto.getLink();
            }
        }catch (XupterException e) {
            log.error("biz error msg "+e.getMessage(),e);
        }catch (Exception e) {
            log.error("sys error msg "+e.getMessage(),e);
        }
        log.info("testXuperUploadFile resp : "+ JsonUtils.toJson(respDto));

        log.info("完整的素材访问fullFilePath url：{}",fullFilePath);
        return  fullFilePath;
    }


    private GalaxySeriesInfoBo buildSeriesInfoBo(GalaxyArtSeriesClaimReqDto reqDto,String taskId,String publishStatus){
        String seriesName = reqDto.getSkuId();
        GalaxySeriesInfoBo seriesInfoBo = GalaxySeriesInfoBo.getNew();
        seriesInfoBo.setSeriesInfoId(IDGenerator.get32UUID());
        seriesInfoBo.setSeriesName(reqDto.getNftName());
        seriesInfoBo.setSeriesCode(seriesName);
        seriesInfoBo.setSeriesId(null);
        seriesInfoBo.setTotalCount(reqDto.getTotalCount());
        seriesInfoBo.setCrtCount(0L);
        seriesInfoBo.setSeriesClaimTaskId(taskId);
        seriesInfoBo.setSeriesClaimStatus(publishStatus);
        seriesInfoBo.setCoverUrl(reqDto.getCoverUrl());
        seriesInfoBo.setSeriesDesc(reqDto.getSeriesDesc());
        seriesInfoBo.setNftCount(1);//系列中nft个数 默认为1
        seriesInfoBo.setRouterType(reqDto.getRouterType());
        seriesInfoBo.setCreatedAt(LocalDateTime.now());
        seriesInfoBo.setUpdatedAt(null);
        return seriesInfoBo;
    }
    private GalaxySeriesNftInfoBo buildSeriesNftInfoBo(GalaxyArtSeriesClaimReqDto reqDto,GalaxySeriesInfoBo seriesInfoBo,GalaxySeriesNftUploadBo seriesNftUploadBo){
        //根据请求参数传入,如有4个skuId,依次传入1，2，3，4
        int nftPublishNumber = 1;

        GalaxySeriesNftInfoBo seriesNftInfoBo = GalaxySeriesNftInfoBo.getNew();
        seriesNftInfoBo.setSeriesNftInfoId(IDGenerator.get32UUID());
        seriesNftInfoBo.setSeriesInfoId(seriesInfoBo.getSeriesInfoId());
        seriesNftInfoBo.setSkuId(reqDto.getSkuId());
        seriesNftInfoBo.setSeriesName(seriesInfoBo.getSeriesName());
        seriesNftInfoBo.setSeriesCode(seriesInfoBo.getSeriesCode());
        seriesNftInfoBo.setSeriesId(seriesInfoBo.getSeriesId());
        //目前要求发行总数必须能整除
        Integer nftTotalCount = BigDecimal.valueOf(seriesInfoBo.getTotalCount()).divide(BigDecimal.valueOf(seriesInfoBo.getNftCount())).intValue();
        seriesNftInfoBo.setNftTotalCount(Long.valueOf(nftTotalCount.toString()));
        seriesNftInfoBo.setNftCrtCount(0L);
        seriesNftInfoBo.setNftIdBegin(null);
        seriesNftInfoBo.setNftIdBeginIndex(BigDecimal.valueOf(nftTotalCount).multiply(BigDecimal.valueOf(nftPublishNumber-1)).intValue()+1);
        seriesNftInfoBo.setNftPublishNumber(nftPublishNumber);
        seriesNftInfoBo.setOriginalNftUrl(seriesNftUploadBo.getOriginalNftUrl());
        seriesNftInfoBo.setOriginalDisplayUrl(seriesNftUploadBo.getOriginalDisplayUrl());
        //以下为购买信息
        seriesNftInfoBo.setAuthor(reqDto.getAuthor());
        seriesNftInfoBo.setNftName(reqDto.getNftName());
        seriesNftInfoBo.setNftUrl(reqDto.getNftUrl());
        seriesNftInfoBo.setDisplayUrl(reqDto.getDisplayUrl());
        seriesNftInfoBo.setNftDesc(reqDto.getNftDesc());
        seriesNftInfoBo.setNftFlag(reqDto.getNftFlag());
        BigDecimal sellCount = new BigDecimal(reqDto.getSellCount()).multiply(BigDecimal.valueOf(100l)); //积分
        seriesNftInfoBo.setSellCount(sellCount);
        seriesNftInfoBo.setNftHash(zxlnftBiz.getHashString(reqDto.getNftUrl()));
        seriesNftInfoBo.setRouterType(reqDto.getRouterType());
        seriesNftInfoBo.setCreatedAt(LocalDateTime.now());
        return seriesNftInfoBo;
    }

    private GalaxyArtSeriesClaimResultQueryRespDto buildGalaxyArtSeriesClaimResultQueryRespDto(GalaxyArtSeriesClaimResultQueryReqDto reqDto, GalaxySeriesInfoBo seriesInfoBo, String taskStatus){
        GalaxyArtSeriesClaimResultQueryRespDto resultQueryRespDto = GalaxyArtSeriesClaimResultQueryRespDto.getNew();
        resultQueryRespDto.setSeriesId(seriesInfoBo.getSeriesId());
        resultQueryRespDto.setChainTimestamp(seriesInfoBo.getChainTimestamp());
        resultQueryRespDto.setTxHash(seriesInfoBo.getTradeHash());
        resultQueryRespDto.setTaskStatus(Integer.valueOf(GalaxyEnumBiz.getTaskStatusEnum(reqDto.getRouterType(),taskStatus).getCode()));

        //获取sku对应nft信息
        GalaxySeriesNftInfoBo seriesNftInfoBo = dataUtils.getSeriesNftInfoBo(reqDto.getRouterType(),reqDto.getSkuId());
        resultQueryRespDto.setNftHash(seriesNftInfoBo.getNftHash());
        return resultQueryRespDto;
    }
}
