package com.liquidnet.service.galaxy.router.xuper.biz;

import com.liquidnet.common.third.xuper.util.XuperSdkUtil;
import com.liquidnet.common.third.zxlnft.dto.Nft016IdentityBindQueryReqDto;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyUserBindStatusQueryReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyUserBindStatusQueryRespDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyUserRegisterReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyUserRegisterRespDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: XuperUserBiz
 * @Package com.liquidnet.service.galaxy.router.xuper.biz
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/6/27 11:11
 */
@Slf4j
@Component
public class XuperUserBiz {
    @Autowired
    private XuperSdkUtil xuperSdkUtil;

    @Autowired
    private XuperUserCommonBiz xuperUserCommonBiz;

    public ResponseDto<GalaxyUserRegisterRespDto> userRegister(GalaxyUserRegisterReqDto reqDto) {
        return xuperUserCommonBiz.userRegister(reqDto);
    }

    public ResponseDto<GalaxyUserBindStatusQueryRespDto> userBindStatusQuery(GalaxyUserBindStatusQueryReqDto reqDto){
        Nft016IdentityBindQueryReqDto nft016ReqDto = Nft016IdentityBindQueryReqDto.getNew();
        nft016ReqDto.setAddressList(reqDto.getBlockChainAddress());
//        ZxlnftResponseDto<Nft016IdentityBindQueryRespDto> zxlnftResponseDto = zxlnftSdkUtil.nft016IdentityBindQuery(nft016ReqDto);
//
        GalaxyUserBindStatusQueryRespDto userBindStatusQueryRespDto = GalaxyUserBindStatusQueryRespDto.getNew();
//        if(zxlnftResponseDto.isSuccess()){
//            Nft016QueryRsData nft016QueryRsData = zxlnftResponseDto.getData().getList().get(0);
//            userBindStatusQueryRespDto.setBlockChainAddress(nft016QueryRsData.getAddress());
//            Integer userBindStatus = Integer.valueOf(GalaxyEnumBiz.getUserBindStatusEnum(reqDto.getRouterType(),nft016QueryRsData.getStatus()).getCode());
//            userBindStatusQueryRespDto.setUserBindStatus(userBindStatus);
//        }else{
//            return ResponseDto.failure();
//        }
        return ResponseDto.success(userBindStatusQueryRespDto);
    }
}
