package com.liquidnet.service.account.wallet.service.impl;

import com.liquidnet.service.account.wallet.entity.FinDictValue;
import com.liquidnet.service.account.wallet.mapper.FinDictValueMapper;
import com.liquidnet.service.account.wallet.service.FinDictService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

@Service
public class FinDictServiceImpl implements FinDictService {
    private static final Logger log = LoggerFactory.getLogger(FinDictServiceImpl.class);
    private static List<FinDictValue> dictValueList = new ArrayList<>();
    private static Map<String, List<FinDictValue>> dictValueListMap = new HashMap<>();
    private static final long EXPIRATION_TIME = 5 * 60 * 1000;
    private static volatile long dictTiming = 0;
    @Autowired
    private FinDictValueMapper dictValueMapper;

    @Override
    public Map<String, String> getDictValueForName(String dictCode) {
        return (Map<String, String>) this.getDictValue(dictCode, false);
    }

    @Override
    public Map<String, FinDictValue> getDictValueForObj(String dictCode) {
        return (Map<String, FinDictValue>) this.getDictValue(dictCode, true);
    }

    /**
     * 查取字典数据
     *
     * @param dictCode
     * @param isObj
     * @return {
     * isObj:true -> Map<FinDictValue.ValueCode, FinDictValue>;
     * isObj:false -> Map<FinDictValue.ValueCode, FinDictValue.ValueName()>;
     * }
     */
    private Map getDictValue(String dictCode, boolean isObj) {
        if (CollectionUtils.isEmpty(dictValueList) || (System.currentTimeMillis() - dictTiming) > EXPIRATION_TIME) {
            dictTiming = System.currentTimeMillis();
            dictValueList = dictValueMapper.selectJoinDict(null);
            dictValueListMap = dictValueList.parallelStream().collect(Collectors.groupingBy(FinDictValue::getDictId));
        }

        List<FinDictValue> dictValueList = dictValueListMap.get(dictCode);
//        List<FinDictValue> dictValueList = dictValueMapper.selectJoinDict(dictCode);

        if (null == dictValueList || dictValueList.isEmpty()) {
            return Collections.emptyMap();
        }
        if (isObj) {
            Map<String, FinDictValue> dictValueMap = new HashMap<>();
            dictValueList.parallelStream().forEach(finDictValue -> dictValueMap.put(finDictValue.getValueCode(), finDictValue));
            return dictValueMap;
        } else {
            Map<String, String> dictValueMap = new HashMap<>();
            dictValueList.parallelStream().forEach(finDictValue -> dictValueMap.put(finDictValue.getValueName(), finDictValue.getValueCode()));
            return dictValueMap;
        }
//        if (isObj) {
//            return dictValueList.stream().collect(Collectors.toMap(FinDictValue::getValueCode, Function.identity(), (k1, k2) -> k2));
//        } else {
//            return dictValueList.stream().collect(Collectors.toMap(FinDictValue::getValueCode, FinDictValue::getValueName, (k1, k2) -> k2));
//        }
    }
}
