package com.liquidnet.service.adam.service;

import com.liquidnet.service.adam.mapper.AdamUserMapper;
import com.liquidnet.service.adam.service.processor.DMAddressesProcessor;
import com.liquidnet.service.adam.service.processor.DMEntersProcessor;
import com.mysql.cj.jdbc.result.ResultSetImpl;
import lombok.SneakyThrows;
import org.springframework.beans.factory.annotation.Autowired;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class DataMigrationProcessorService {
    public static final String DM_FLG = "flg";
    public static final String DM_FLUSH = "flu";
    public static List<String> reUidList = new ArrayList<>();
    static {
        reUidList.addAll(Arrays.asList("1406834", "1406870", "1406872", "1480154", "1480182", "1480185", "1480188", "1480192", "1416286", "1416315", "576723", "716461", "1405052", "1405054", "1165127", "1165128", "1338315", "1338318", "1563075", "1563171", "1155903", "1155904", "998047", "998049", "1005624", "1005626", "1325133", "1325141", "1325144", "1522323", "1522327", "1634494", "1634518", "1416230", "1416245", "1416256", "1416269", "1416284", "1416299", "1416323", "1469580", "1469582", "1469585", "1469597", "1469602", "1469620", "1469644", "919572", "919573", "1306189", "1306190", "1424617", "1424618", "1303823", "1303824", "1303825", "1303826", "1405071", "1405085", "1482373", "1482385", "1482386", "1482389", "1399984", "1399995", "1313607", "1313609", "1469586", "1469590", "1469601", "1469633", "1469646", "1626361", "1626372", "1090622", "1090623", "1352248", "1352253", "1352254", "1018609", "1018611", "1018614", "1018615", "1299829", "1299830", "1634471", "1634473", "981756", "981757", "927692", "927693", "1619686", "1619695", "1619710", "1619718", "1619726", "1626341", "1626349", "1626351", "1626374", "811095", "811096", "1327425", "1327430", "1477324", "1477334", "1477353", "1409779", "1409786", "1626337", "1626363", "878546", "878547", "1562936", "1563005", "1563116", "1563197", "1626340", "1626345", "1626380", "1033586", "1033587", "1033588", "1033589", "1562802", "1562848", "871254", "871255", "1512602", "1512641"));
    }

    @Autowired
    public AdamUserMapper userMapper;

    public Connection connection = null;
    public PreparedStatement statement = null;
    public ResultSetImpl row = null;

    public void handler() {
        preHandler();

        try {
            dataProcessing();
        } catch (Exception e) {
            e.printStackTrace();
        }

        postHandler();
    }

    @SneakyThrows
    private void preHandler() {
        Class.forName("com.mysql.cj.jdbc.Driver");
        String url = "jdbc:mysql://pc-2ze6z2hxkug559q79.mysql.polardb.rds.aliyuncs.com:3306/";
//        String url = "jdbc:mysql://zhengzai.mysql.polardb.rds.aliyuncs.com:3306/";
        if (this instanceof DMEntersProcessor || this instanceof DMAddressesProcessor) {
            url += "mall";
        } else {
            url += "passport";
        }
        connection = DriverManager.getConnection(url, "readonly", "ZWDsf8Fy");
    }

    protected abstract void dataProcessing();

    private void postHandler() {
        try {
            assert row != null;
            row.close();
            statement.close();
            connection.close();
        } catch (SQLException throwables) {
            throwables.printStackTrace();
        }
    }
}
