package com.liquidnet.client.admin.web.controller.zhengzai.kylin;

import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.zhengzai.kylin.service.impl.PerformancesExpressServiceImpl;
import com.liquidnet.client.admin.zhengzai.kylin.utils.ShunfengSignUtils;
import com.liquidnet.service.kylin.dao.PerformanceExpressPerformanceListAdminDao;
import com.liquidnet.service.kylin.dao.PerformanceExpressPerformanceOrderListAdminDao;
import com.liquidnet.service.kylin.dto.param.PerformanceExpressSearchAdminParam;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 演出快递
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-06-21
 */

@Controller
@RequestMapping("/kylin/performancesExpress")
public class PerformancesExpressController extends BaseController {

    private String prefix = "zhengzai/kylin/performancesExpress";

    @Value("${liquidnet.shunfeng.url}")
    private String url;
    @Value("${liquidnet.shunfeng.sk}")
    private String sk;
    @Value("${liquidnet.shunfeng.appid}")
    private String appid;

    @Autowired
    private PerformancesExpressServiceImpl performancesExpressServiceImpl;

    /**
     * 查询演出列表
     */
    @RequiresPermissions("kylin:performancesExpress:view")
    @GetMapping()
    public String performancesListView() {
        return prefix + "/performancesList";
    }

    @RequiresPermissions("kylin:performancesExpress:performancesList")
    @PostMapping("/performancesList")
    @ResponseBody
    public TableDataInfo performancesList(PerformanceExpressSearchAdminParam performanceExpressSearchAdminParam) {
        List<PerformanceExpressPerformanceListAdminDao> result = performancesExpressServiceImpl.getPerformancesList(performanceExpressSearchAdminParam);
        return getDataTable(result);
    }

    /**
     * 查询演出订单列表
     */
    @RequiresPermissions("kylin:performancesExpress:performanceOrderList")
    @GetMapping("performanceOrderList/{id}")
    public String performanceOrderListView(@PathVariable("id") String id, ModelMap mmap) {
        mmap.put("performancesId", id);
        return prefix + "/performanceOrderList";
    }

    @RequiresPermissions("kylin:performancesExpress:performanceOrderList")
    @PostMapping("/performanceOrderList")
    @ResponseBody
    public TableDataInfo performanceOrderList(PerformanceExpressSearchAdminParam performanceExpressSearchAdminParam) {
        List<PerformanceExpressPerformanceOrderListAdminDao> result = performancesExpressServiceImpl.getPerformancesOrderList(performanceExpressSearchAdminParam);
        return getDataTable(result);
    }

    /**
     * 下单
     */
    @RequiresPermissions("kylin:performancesExpress:placeOrder")
    @PostMapping("/placeOrder")
    @ResponseBody
    public boolean placeOrder() {
        // 请求body companyId参数值和APPID一致！！！
        String body="{\"dContact\":\"王昆\",\"companyId\":{{APP_ID}},\"jContact\":\"顺丰\",\"jTel\":\"111\",\"jMobile\":null,\"jAddress\":\"马甸\",\"dTel\":\"064756935\",\"dMobile\":null,\"dAddress\":\"北京市朝阳区花家地金兴路1号院5号楼1单元202\",\"custid\":\"7551234567\",\"payMethod\":\"0\",\"expressType\":\"1\",\"packagesNo\":\"1\",\"depositumInfo\":\"TCL空调\",\"depositumNo\":\"1\",\"remark\":null,\"isCollection\":\"1\",\"collectionMoney\":\"10.00\",\"isReceipt\":\"0\",\"receipt\":null}";
        // 时间戳
        long currentTimeMillis = System.currentTimeMillis();
        System.out.println("时间戳:"+currentTimeMillis);

        // 生成签名并请求
        String result = ShunfengSignUtils.generateSignatureAndRequest(currentTimeMillis + "", body);
        System.out.println("响应:"+result);
        return true;
    }

}
