package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;


/**
 * @author TT
 */
@Data
public class GoblinGoodsAnticipateShareVo  implements Serializable{

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    private String sid;

    /**
     * 用户uid
     */
    private String uid;

    /**
     * sku_Id
     */
    private String skuId;

    /**
     * url分享地址（备用）
     */
    private String url;

    /**
     * 预约开始时间
     */
    @ApiModelProperty(value = "预约开始时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime aboutStartDate;

    /**
     * 预约结束时间
     */
    @ApiModelProperty(value = "预约结束时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime aboutEndDate;

    /**
     * 创建时
     */
    private LocalDateTime createdDate;


    private static final GoblinGoodsAnticipateShareVo obj = new GoblinGoodsAnticipateShareVo();

    public static GoblinGoodsAnticipateShareVo getNew() {
        try {
            return (GoblinGoodsAnticipateShareVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinGoodsAnticipateShareVo();
        }
    }


}
