package com.liquidnet.service.platform.controller.partner;


import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dao.ChildDetailsDao;
import com.liquidnet.service.kylin.dao.ChildListDao;
import com.liquidnet.service.kylin.service.partner.IKylinCheckUserPartnerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.hibernate.validator.constraints.Length;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * <p>
 * 验票用户表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-21
 */
@Api(tags = "第三方-验票账号")
@RestController
@RequestMapping("partner/checkUser")
@Validated
public class KylinCheckUserPartnerController {

    @Autowired
    private IKylinCheckUserPartnerService checkUserPartnerService;

    @PostMapping(value = "")
    @ApiOperation(value = "创建验票账号", position = 1)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> create(@RequestParam("merchantId") @NotNull String merchantId,
                                      @RequestParam("name") @NotNull String name,
                                      @RequestParam("pwd") @NotNull String pwd,
                                      @RequestParam("mobile") @NotNull @Length(max = 11) String mobile) {
        return checkUserPartnerService.create(merchantId, name, pwd, mobile);
    }

    @DeleteMapping(value = "")
    @ApiOperation(value = "删除验票账号", position = 1)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> del(@RequestParam("merchantId") @NotNull String merchantId,
                                   @RequestParam("checkUserId") @NotNull String checkUserId) {
        return checkUserPartnerService.del(merchantId, checkUserId);
    }

    @PostMapping(value = "change")
    @ApiOperation(value = "修改验票账号", position = 1)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> change(@RequestParam("merchantId") @NotNull String merchantId,
                                      @RequestParam("checkUserId") @NotNull String checkUserId,
                                      @RequestParam("name") @NotNull String name,
                                      @RequestParam(value = "pwd",required = false) @NotNull String pwd,
                                      @RequestParam("mobile") @Length(max = 11) String mobile) {
        return checkUserPartnerService.change(merchantId, checkUserId, name, pwd, mobile);
    }

    @GetMapping(value = "list")
    @ApiOperation(value = "验票账号列表", position = 1)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PageInfo<ChildListDao>> getCheckUserList(@RequestParam("merchantId") @NotNull String merchantId,
                                                                    @RequestParam(value = "mobile" , required = false) @Length(max = 11) String mobile,
                                                                    @RequestParam("page") @NotNull @Min(1) int page,
                                                                    @RequestParam("size") @NotNull @Min(1)int size) {
        PageInfo<ChildListDao> result = checkUserPartnerService.getCheckUserList(merchantId,mobile,page,size);
        if (null == result) {
            return ResponseDto.failure("查询失败");
        } else {
            return ResponseDto.success(result);
        }
    }

    @GetMapping(value = "details")
    @ApiOperation(value = "验票账号详情", position = 1)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<ChildDetailsDao> details(@RequestParam("merchantId") @NotNull String merchantId,
                                                @RequestParam("checkUserId") @NotNull String checkUserId) {
        ResponseDto<ChildDetailsDao> result = checkUserPartnerService.details(merchantId,checkUserId);
        if (null == result) {
            return ResponseDto.failure("查询失败");
        } else {
            return result;
        }
    }

}
