package com.liquidnet.service.galaxy.service.impl;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftBuyReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftBuyRespDto;
import com.liquidnet.service.galaxy.router.strategy.GalaxyRouterStrategyContext;
import com.liquidnet.service.galaxy.service.IGalaxyPublishService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyPublishServiceImpl
 * @Package com.liquidnet.service.galaxy.service.impl
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/15 11:28
 */
@Slf4j
@Service
public class GalaxyPublishServiceImpl implements IGalaxyPublishService {
    @Autowired
    private GalaxyRouterStrategyContext galaxyRouterStrategyContext;

    @Override
    public ResponseDto<GalaxyNftBuyRespDto> nftBuy(GalaxyNftBuyReqDto reqDto) {
        return galaxyRouterStrategyContext.getStrategy(reqDto.getRouteType()).nftBuy(reqDto);
    }
}
