package com.liquidnet.common.mq.handle;

import com.liquidnet.common.mq.constant.GlobalConstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author <a href="mailto:guo_xp@163.com">guoxinpeng</a>
 * @version 1.0 2016/11/26 12:03
 * @projectname new-pay
 * @packname com.liquidnet.service.common.mqservice
 */
@Service
public class SendMqService{

  @Autowired
  private SendMQ sendMQ;

  public <T> T sendMsgServiceXml(String routingKey, T obj){
    sendMQ.sendMsg(routingKey, obj, System.currentTimeMillis()+"", GlobalConstant.XML);
    return obj;
  }
  public <T> T sendMsgAndReceiveServiceXml(String routingKey, T obj){
    sendMQ.sendMsgAndReceive(routingKey, obj, System.currentTimeMillis()+"", GlobalConstant.XML,obj.getClass());
    return obj;
  }

    public <T> T sendMsgServiceJson(String routingKey, T obj){
        sendMQ.sendMsg(routingKey, obj, System.currentTimeMillis()+"", GlobalConstant.JSON);
        return obj;
    }
    public <T> T sendMsgAndReceiveServiceJson(String routingKey, T obj){
        sendMQ.sendMsgAndReceive(routingKey, obj, System.currentTimeMillis()+"", GlobalConstant.XML,obj.getClass());
        return obj;
    }

    public <T> T sendMsg(String routingKey, T obj){
        sendMQ.sendMsg(routingKey, String.valueOf(obj), System.currentTimeMillis()+"");
        return obj;
    }

}
