package com.liquidnet.service.bank.currencycloud.controller;

import com.currencycloud.client.model.Transactions;
import com.liquidnet.common.exception.constant.ErrorCode;
import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.bank.config.swagger.BankSwaggerApiVersionConstant;
import com.liquidnet.service.bank.currencycloud.dto.BankCcPushNotifyParam;
import com.liquidnet.service.bank.currencycloud.service.IBankCcPushNotifyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2020-10-22
 */
@Api(tags = "push notify")
@Slf4j
@RestController
@RequestMapping("/bank-cc-push-notify")
public class BankCcPushNotifyController {

    @Autowired
    IBankCcPushNotifyService bankCcPushNotifyService;

    @ApiOperation(value = "push transaction")
    @SwaggerApiVersion(group = BankSwaggerApiVersionConstant.API_CC)
    @PostMapping("/transaction")
    public ResponseDto<Transactions> transaction(HttpServletRequest request,
                                                 @RequestBody BankCcPushNotifyParam pushNotifyParam) {
        String logFx = "push notify funding transaction.";
        log.info(logFx + "BankCcPushNotifyParam=[{}]", pushNotifyParam);
        try {
            return bankCcPushNotifyService.pushNotify(pushNotifyParam);

        } catch (Exception e) {
            log.error(logFx + "error", e);
            return ResponseDto.failure(ErrorCode.HTTP_SYSTEM_ERROR);
        }

    }

}
