package com.liquidnet.service.reconciliation.strategy.infodata.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.account.common.FinConstants;
import com.liquidnet.service.adam.constant.AdamFundingConstants;
import com.liquidnet.service.adam.constant.AdamTransactionConstants;
import com.liquidnet.service.api.sequence.feign.FeignSequenceClient;
import com.liquidnet.service.reconciliation.constant.ReconConstants;
import com.liquidnet.service.reconciliation.constant.ReconConstants.BankChannelEnum;
import com.liquidnet.service.reconciliation.constant.ReconConstants.TransStatusEnum;
import com.liquidnet.service.reconciliation.entity.LrFundflowLiquidnetWallet;
import com.liquidnet.service.reconciliation.entity.LrInfoflowLiquidnetAdam;
import com.liquidnet.service.reconciliation.entity.adam.AdamTransaction;
import com.liquidnet.service.reconciliation.entity.wallet.FinWlN07;
import com.liquidnet.service.reconciliation.service.ILrFundflowLiquidnetWalletService;
import com.liquidnet.service.reconciliation.service.ILrInfoflowLiquidnetAdamService;
import com.liquidnet.service.reconciliation.service.adam.IAdamTransactionService;
import com.liquidnet.service.reconciliation.strategy.infodata.IGetInfoDataStrategy;
import com.liquidnet.service.reconciliation.strategy.infodata.annotation.StrategyGetInfoDataHandler;
import com.liquidnet.service.reconciliation.vo.ReconciliationEntityVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: liquidnet-wallet
 * @class: LiquidnetWalletGetFundDataStrategyImpl
 * @Package com.liquidnet.service.reconciliation.strategy.transtype.impl
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/10/27 14:58
 */
@Slf4j
@Component
@StrategyGetInfoDataHandler(BankChannelEnum.LIQUIDNET_ADAM)
public class GetInfoDataStrategyLiquidnetAdamImpl implements IGetInfoDataStrategy {
    @Autowired
    private FeignSequenceClient feignSequenceClient;

    @Autowired
    private IAdamTransactionService adamTransactionService;

    @Override
    public List<ReconciliationEntityVo> getTransInfoData(Map<String, Object> paramMap) {
        //查询参数
        String beginDate = paramMap.get("beginDate").toString();
        String endDate = paramMap.get("endDate").toString();
        String onlySuccess = paramMap.get("onlySuccess").toString();
        String status = paramMap.get("status").toString();
        //查询条件
        log.info("getTransInfoData bankChannel:{} beginDate:{} endDate:{} onlySuccess:{} status:{}",BankChannelEnum.LIQUIDNET_ADAM.getCode()
                ,beginDate,endDate,onlySuccess,status);

        LambdaQueryWrapper<AdamTransaction> wrapper = new LambdaQueryWrapper<>();
        if(!StringUtils.isEmpty(beginDate)){
            try {
                wrapper.ge(AdamTransaction::getCreateTime, DateUtil.parse(beginDate,DateUtil.DATE_SMALL_STR));
            } catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if(!StringUtils.isEmpty(endDate)){
            try {
                wrapper.lt(AdamTransaction::getCreateTime, DateUtil.addDay(DateUtil.parse(endDate,DateUtil.DATE_SMALL_STR),1));
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        if(StringUtil.isNotNull(onlySuccess)&&Boolean.parseBoolean(onlySuccess)){
            wrapper.in(AdamTransaction::getStatus,status);
        }


        List<AdamTransaction>  infoFlowList = adamTransactionService.list(wrapper);

        List<ReconciliationEntityVo> reconList = new ArrayList<>();
        infoFlowList.stream().forEach(fundRecord ->{
            ReconciliationEntityVo reconVo = ReconciliationEntityVo.getNew();
            reconVo.setId(feignSequenceClient.nextId().toString());
            reconVo.setBankChannel(BankChannelEnum.LIQUIDNET_ADAM.getCode());
//            reconVo.setBatchNo();
//            reconVo.setBillDate();
            reconVo.setOrderNo(fundRecord.getNumber());
            reconVo.setTransactionId(fundRecord.getId());
            if(fundRecord.getType().equalsIgnoreCase(AdamTransactionConstants.TypeEnum.FUNDING.getCode())){
                reconVo.setTransType(ReconConstants.TransTypeEnum.RECHARGE.getCode());
            }else if(fundRecord.getType().equalsIgnoreCase(AdamTransactionConstants.TypeEnum.PAYOUT.getCode())){
                reconVo.setTransType(ReconConstants.TransTypeEnum.PAYOUT.getCode());
            }else if(fundRecord.getType().equalsIgnoreCase(AdamTransactionConstants.TypeEnum.FX_CONVERSION.getCode())){
                reconVo.setTransType(ReconConstants.TransTypeEnum.EXCHANGE.getCode());
            }
            reconVo.setCurrency(fundRecord.getCurrency());
            reconVo.setAmount(fundRecord.getFundAmount());
            reconVo.setCostFee(BigDecimal.ZERO);
//            reconVo.setRefundAmount();
            if(fundRecord.getStatus().equalsIgnoreCase(AdamFundingConstants.StatusEnum.COMPLETED.getCode())){
                reconVo.setTradeStatus(TransStatusEnum.SUCCESS.name());
            }else if(fundRecord.getStatus().equalsIgnoreCase(AdamFundingConstants.StatusEnum.FAILED.getCode())){
                reconVo.setTradeStatus(TransStatusEnum.FAILED.name());
            }else if(fundRecord.getStatus().equalsIgnoreCase(AdamFundingConstants.StatusEnum.PROCESSING.getCode())){
                reconVo.setTradeStatus(TransStatusEnum.PROCESSING.name());
            }else{
                reconVo.setTradeStatus(TransStatusEnum.UNKNOWN.name());
            }
//            reconVo.setRefTransId();
//            reconVo.setCheckResult();
//            reconVo.setOrderTime();
//            reconVo.setTransDate();
//            reconVo.setTransTime();
//            reconVo.setBankOrderNo();
//            reconVo.setBankTrxNo();
            reconList.add(reconVo);
        });
        return reconList;
    }
}
