package com.liquidnet.service.adam.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.commons.lang.util.JwtUtil;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.dto.vo.AdamThirdPartInfoVo;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

@Api(tags = "用户登录")
@Slf4j
@RestController
@RequestMapping("login")
public class AdamUserAuthController {

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "手机号密码登录")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "mobile", value = "手机号"),
            @ApiImplicitParam(type = "form", dataType = "String", name = "password", value = "密码"),
    })
    @PostMapping(value = {""})
    public ResponseDto<Object> loginByPwd(@RequestParam String mobile, @RequestParam String password) {
        log.info("mobile:{},pwd:{}", mobile, password);

        Map<String, Object> claimsMap = new HashMap<>(), rstMap = new HashMap<>();
        claimsMap.put("username", "zhanggb");
        claimsMap.put("uid", "2021");
        String token = JwtUtil.create(claimsMap);
        log.info("token:{}", token);

        rstMap.put("token", token);
        rstMap.put("userInfo", AdamUserInfoVo.getNew());
        rstMap.put("thiredPartInfo", AdamThirdPartInfoVo.getNew());
        // TODO: 2021/5/10 会员信息
        rstMap.put("cardsInfo", null);

        return ResponseDto.success(rstMap);
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "发送验证码")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "mobile", value = "手机号"),
    })
    @GetMapping(value = {"send/{mobile}"})
    public ResponseDto<Object> sendSms(@PathVariable String mobile) {
        log.info("send to mobile:{}", mobile);

        // TODO: 2021/5/10


        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "手机号验证码登录")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "mobile", value = "手机号"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "code", value = "验证码"),
    })
    @PostMapping(value = {"sms"})
    public ResponseDto<Object> loginBySms(@RequestParam String mobile, @RequestParam String code) {
        log.info("mobile:{},pwd:{}", mobile, code);

        Map<String, Object> claimsMap = new HashMap<>(), rstMap = new HashMap<>();
        claimsMap.put("username", "zhanggb");
        claimsMap.put("uid", "2021");
        String token = JwtUtil.create(claimsMap);
        log.info("token:{}", token);

        rstMap.put("token", token);
        rstMap.put("userInfo", AdamUserInfoVo.getNew());
        rstMap.put("thiredPartInfo", AdamThirdPartInfoVo.getNew());
        // TODO: 2021/5/10 会员信息
        rstMap.put("cardsInfo", null);

        return ResponseDto.success(token);
    }

    @ApiOperationSupport(order = 4)
    @ApiOperation(value = "手机号一键登录")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "accessToken", value = "访问令牌"),
    })
    @PostMapping(value = {"tpa/mobile"})
    public ResponseDto<Object> loginByTpaMobile(@RequestParam String accessToken) {

        log.info("login by mobile access token:{}", accessToken);

        // TODO: 2021/5/10


        Map<String, Object> claimsMap = new HashMap<>(), rstMap = new HashMap<>();
        claimsMap.put("username", "zhanggb");
        claimsMap.put("uid", "2021");
        String token = JwtUtil.create(claimsMap);
        log.info("token:{}", token);

        rstMap.put("token", token);
        rstMap.put("userInfo", AdamUserInfoVo.getNew());
        rstMap.put("thiredPartInfo", AdamThirdPartInfoVo.getNew());
        // TODO: 2021/5/10 会员信息
        rstMap.put("cardsInfo", null);

        return ResponseDto.success(rstMap);
    }

    @ApiOperationSupport(order = 5)
    @ApiOperation(value = "第三方账号登录")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "openId", value = "第三方OPENID"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "nickName", value = "昵称"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "avatar", value = "头像"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "platform", value = "平台类型", allowableValues = "WEIBO,WECHAT,QQ"),
    })
    @PostMapping(value = {"tpa"})
    public ResponseDto<Object> loginByTpa(@RequestParam String openId, @RequestParam String nickname,
                                          @RequestParam String avatar, @RequestParam String platform) {
        log.info("login by tpa openId:{}, nickname:{}, avatar: {}, platform:{}", openId, nickname, avatar, platform);

        // TODO: 2021/5/10
        Map<String, Object> claimsMap = new HashMap<>(), rstMap = new HashMap<>();
        claimsMap.put("username", "zhanggb");
        claimsMap.put("uid", "2021");
        String token = JwtUtil.create(claimsMap);
        log.info("token:{}", token);

        rstMap.put("token", token);
        rstMap.put("userInfo", AdamUserInfoVo.getNew());
        rstMap.put("thiredPartInfo", AdamThirdPartInfoVo.getNew());
        // TODO: 2021/5/10 会员信息
        rstMap.put("cardsInfo", null);

        return ResponseDto.success(rstMap);
    }

    @ApiOperationSupport(order = 6)
    @ApiOperation(value = "第三方账号注册")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "openId", value = "第三方OPENID"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "nickname", value = "昵称"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "avatar", value = "头像"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "platform", value = "平台类型", allowableValues = "WEIBO,WECHAT,QQ"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "mobile", value = "手机号"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "platform", value = "验证码"),
    })
    @PostMapping(value = {"tpa/reg"})
    public ResponseDto<Object> loginByTpaRegister(@RequestParam String openId, @RequestParam String nickname,
                                                  @RequestParam String avatar, @RequestParam String platform,
                                                  @RequestParam String mobile, @RequestParam String code) {
        log.info("login by tpa openId:{},nickname:{},avatar:{},platform:{},mobile:{},code:{}",
                openId, nickname, avatar, platform, mobile, code);

        // TODO: 2021/5/10
        Map<String, Object> claimsMap = new HashMap<>(), rstMap = new HashMap<>();
        claimsMap.put("username", "zhanggb");
        claimsMap.put("uid", "2021");
        String token = JwtUtil.create(claimsMap);
        log.info("token:{}", token);

        rstMap.put("token", token);
        rstMap.put("userInfo", AdamUserInfoVo.getNew());
        rstMap.put("thiredPartInfo", AdamThirdPartInfoVo.getNew());
        // TODO: 2021/5/10 会员信息
        rstMap.put("cardsInfo", null);

        return ResponseDto.success(rstMap);
    }
}
