package com.liquidnet.service.adam.controller.admin;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.dto.AdamMemberPriceParam;
import com.liquidnet.service.adam.dto.vo.AdamMemberPriceVo;
import com.liquidnet.service.adam.entity.AdamMemberPrice;
import com.liquidnet.service.adam.service.admin.IAdamMemberPriceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@Api(tags = "会员价格")
@Slf4j
@RestController
@RequestMapping("/member/price")
public class AdamMemberPriceController {
    @Autowired
    IAdamMemberPriceService adamMemberPriceService;

    @ApiOperationSupport(order = 0)
    @ApiOperation(value = "会员价格列表")
    @GetMapping("list/{memberId}")
    public ResponseDto<Object> list(@PathVariable(name = "memberId") String memberId) {
        List<AdamMemberPrice> list = adamMemberPriceService.list(memberId);
        List<AdamMemberPriceVo> adamMemberPriceVos = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            AdamMemberPriceVo apv = new AdamMemberPriceVo();
            AdamMemberPrice amp = list.get(i);
            BeanUtils.copyProperties(amp, apv);
            apv.setCreatedAt(DateUtil.format(amp.getCreatedAt(), DateUtil.Formatter.yyyyMMddHHmmss));
            apv.setUpdatedAt(DateUtil.format(amp.getUpdatedAt(), DateUtil.Formatter.yyyyMMddHHmmss));
            adamMemberPriceVos.add(apv);
        }
        return ResponseDto.success(adamMemberPriceVos);
    }

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "会员价格详情")
    @GetMapping("info/{memberPriceId}")
    public ResponseDto<Object> query(@PathVariable(name = "memberPriceId") String memberPriceId){
        AdamMemberPrice adamMemberPrice = adamMemberPriceService.query(memberPriceId);
        AdamMemberPriceVo adamMemberPriceVo = new AdamMemberPriceVo();
        BeanUtils.copyProperties(adamMemberPrice, adamMemberPriceVo);
        adamMemberPriceVo.setCreatedAt(DateUtil.format(adamMemberPrice.getCreatedAt(), DateUtil.Formatter.yyyyMMddHHmmss));
        adamMemberPriceVo.setUpdatedAt(DateUtil.format(adamMemberPrice.getUpdatedAt(), DateUtil.Formatter.yyyyMMddHHmmss));
        return ResponseDto.success(adamMemberPriceVo);
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "添加会员价格")
    @PostMapping("add")
    public ResponseDto<Object> add(@RequestBody AdamMemberPriceParam param) {
        AdamMemberPrice entity = new AdamMemberPrice();
        BeanUtils.copyProperties(param, entity);
        adamMemberPriceService.add(entity);
        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "编辑会员价格")
    @PostMapping("edit")
    public ResponseDto<Object> edit(@RequestBody AdamMemberPriceParam param) {
        AdamMemberPrice entity = new AdamMemberPrice();
        BeanUtils.copyProperties(param, entity);
        adamMemberPriceService.edit(entity);
        return ResponseDto.success();
    }
}
