package com.liquidnet.service.kylin.service.partner;

import com.baomidou.mybatisplus.extension.service.IService;
import com.liquidnet.service.kylin.dto.param.TicketCreateParam;
import com.liquidnet.service.kylin.dto.vo.partner.TicketPartnerVo;
import com.liquidnet.service.kylin.entity.KylinTickets;

import java.util.List;

/**
 * <p>
 * 票 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-06
 */
public interface IKylinTicketsPartnerService extends IService<KylinTickets> {

    /**
     * 创建票汇总
     * @param ticketCreateParam
     * @return
     */
    TicketPartnerVo createTicketSummary(TicketCreateParam ticketCreateParam);

    /**
     * 未通过审核创建票
     * @param ticketCreateParam
     * @return
     */
    TicketPartnerVo createTicket(TicketCreateParam ticketCreateParam);

    /**
     * 通过审核后创建场次
     * @param ticketCreateParam
     * @return
     */
    TicketPartnerVo addNewTicket(TicketCreateParam ticketCreateParam);

    TicketPartnerVo updateTicket(TicketCreateParam ticketCreateParam);

    /**
     * 删除 票(只有未审核通过可删除)
     * @param ticketsId
     * @return
     */
    boolean deleteTicket(String ticketsId);

    TicketPartnerVo copyTicket(String ticketsId);

    boolean submitTicketByTimes(String timesId);

    List<TicketPartnerVo> getTicketMongoList(String timesId);

    TicketPartnerVo getTicketsMongo(String ticketsId);
}
