package com.liquidnet.service.kylin.controller;


import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.kylin.dao.BannerDetailsListDao;
import com.liquidnet.service.kylin.dto.param.BannersApiSearchParam;
import com.liquidnet.service.kylin.dto.param.BannersSearchParam;
import com.liquidnet.service.kylin.dto.vo.BannersVo;
import com.liquidnet.service.kylin.dto.vo.PagerVo;
import com.liquidnet.service.kylin.service.impl.admin.KylinBannersServiceImpl;
import com.mongodb.client.AggregateIterable;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 轮播图 前端接口控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-10
 */

@Api(tags = "前端-banner")
@RestController
@RequestMapping("banners")
public class KylinBannersController {

    @Autowired
    private KylinBannersServiceImpl kylinBannersServiceImpl;

    @GetMapping("")
    @ApiOperation("banner列表")
    public ResponseDto<List<BannersVo>> blist(
            @RequestParam(value = "position") String position,
            @RequestParam(value = "provinceCode", defaultValue = "") String provinceCode
    ) {
        BannersApiSearchParam bannersApiSearchParam = new BannersApiSearchParam();
        bannersApiSearchParam.setPosition(position);
        bannersApiSearchParam.setProvinceCode(provinceCode);
        List result = kylinBannersServiceImpl.blist(bannersApiSearchParam);

        if (result.size() > 0) {
            return ResponseDto.success(result);
        } else {
            return ResponseDto.failure("获取列表失败");
        }
    }

}
