package com.liquidnet.service.goblin.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 热词

 * </p>
 *
 * @author liquidnet
 * @since 2021-12-28
 */
@ApiModel(value = "GoblinFrontHotWordBuildParam", description = "热词")
@Data
public class GoblinFrontHotWordBuildParam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @ApiModelProperty(value = "主键")
    private Long mid;

    /**
     * 热词
     */
    @ApiModelProperty(value = "热词")
    private String word;

    /**
     * 1开启2未开启
     */
    @ApiModelProperty(value = "1开启2未开启")
    private Integer status;

    /**
     * 排序
     */
    @ApiModelProperty(value = "排序")
    private Integer indexs;

    /**
     * 1、滚动2、按时切换
     */
    @ApiModelProperty(value = "1、滚动2、按时切换")
    private Integer changeType;

    /**
     * 切换时间单位为s
     */
    @ApiModelProperty(value = "切换时间单位为s")
    private Integer changeTime;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    /**
     * 修改时间
     */
    @ApiModelProperty(value = "创建时间")
    private LocalDateTime updateTime;

    /**
     * 热词id
     */
    @ApiModelProperty(value = "热词id")
    private String hotWordId;

    /**
     * 0未删除1已删除
     */
    @ApiModelProperty(value = "0未删除1已删除")
    private Integer delTag;


}
