package com.liquidnet.service.goblin.service.impl.manage;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.goblin.dto.vo.GoblinSelfGoodsCategoryVo;
import com.liquidnet.service.goblin.dto.vo.GoblinSelfTagVo;
import com.liquidnet.service.goblin.dto.vo.GoblinServiceSupportVo;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreMgtExtraService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.QueueUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.LinkedList;
import java.util.List;

@Service
public class GoblinStoreMgtExtraServiceImpl implements IGoblinStoreMgtExtraService {
    @Autowired
    private QueueUtils queueUtils;
    @Autowired
    private GoblinRedisUtils goblinRedisUtils;
    @Autowired
    private GoblinMongoUtils goblinMongoUtils;

    @Override
    public List<GoblinSelfGoodsCategoryVo> listCategoryVo() {
        return goblinRedisUtils.getSelfGoodsCategoryVos();
    }

    @Override
    public List<GoblinSelfTagVo> listTagVo(String keyword, String belong, String... typeRange) {
        return goblinMongoUtils.getSelfTagVos(keyword, belong, typeRange);
    }

    @Override
    public List<GoblinServiceSupportVo> listServiceSupportVo() {
        List<GoblinServiceSupportVo> serviceSupportVos = goblinRedisUtils.getServiceSupportVos();
        if (CollectionUtils.isEmpty(serviceSupportVos)) {
            serviceSupportVos.add(GoblinServiceSupportVo.getNew().setName("正品保证").setDesc("商品为正版行货").setSsid("101"));
            serviceSupportVos.add(GoblinServiceSupportVo.getNew().setName("极速发货").setDesc("24小时内发送货物").setSsid("102"));
            serviceSupportVos.add(GoblinServiceSupportVo.getNew().setName("无忧退货").setDesc("支持7天无理由退款").setSsid("103"));

            goblinMongoUtils.insertMgtServiceSupportVos(serviceSupportVos);

            LinkedList<Object[]> upsertServiceSupportObjs = CollectionUtil.linkedListObjectArr();
            serviceSupportVos.forEach(vo -> upsertServiceSupportObjs.add(new Object[]{vo.getSsid(), vo.getName(), vo.getDesc(), vo.getUrl()}));

            queueUtils.sendMsgByRedis(MQConst.GoblinQueue.SQL_STORE.getKey(),
                    SqlMapping.get("goblin_service_support.insert_by_replace", upsertServiceSupportObjs));
        }
        return serviceSupportVos;
    }
}
