package com.liquidnet.service.dragon.service.impl;

import com.alipay.api.AlipayClient;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.response.AlipayTradeRefundResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.liquidnet.service.dragon.service.IDragonOrderRefundsService;
import com.liquidnet.service.dragon.utils.PayAlipayUtils;
import com.liquidnet.service.dragon.utils.PayWepayUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;

@Service
public class DragonOrderRefundsServiceImpl implements IDragonOrderRefundsService {

    @Autowired
    StringRedisTemplate stringRedisTemplate;

    @Override
    public void sendRedisQueue() {
//        try {
//            HashMap<String ,String> map = new HashMap<>();
//            map.put("message","测试 redis 订阅信息1");
//            MapRecord<String, String, String> record = StreamRecords.mapBacked(map).withStreamKey("dragon-refund");
//            stringRedisTemplate.opsForStream().add(record);
//        }catch (Exception e){
//            e.printStackTrace();
//        }

        try {
            PayWepayUtils payWepayUtils = new PayWepayUtils();
            HttpPost httpPost = new HttpPost("https://api.mch.weixin.qq.com/v3/pay/transactions/jsapi");
            httpPost.addHeader("Accept", "application/json");
            httpPost.addHeader("Content-type", "application/json; charset=utf-8");

            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectMapper objectMapper = new ObjectMapper();

            ObjectNode rootNode = objectMapper.createObjectNode();
            rootNode.put("mchid", "1551961491")
                    .put("appid", "wx3498304dda39c5a1")
                    .put("description", "Image形象店-深圳腾大-QQ公仔")
                    .put("notify_url", "https://www.weixin.qq.com/wxpay/pay.php")
                    .put("out_trade_no", "1217752501201407033233368018");
            rootNode.putObject("amount")
                    .put("total", 1);
            rootNode.putObject("payer")
                    .put("openid", "oUpkkuHUgiyTYE4ZU8Y5Sga-znWQ");

            objectMapper.writeValue(bos, rootNode);

            httpPost.setEntity(new StringEntity(bos.toString("UTF-8"), "UTF-8"));
            CloseableHttpResponse response = payWepayUtils.getHttpClient().execute(httpPost);

            String bodyAsString = EntityUtils.toString(response.getEntity());
            System.out.println(bodyAsString);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dragonRefund(String trade_no, String out_trade_no, String reason, String returnUrl, BigDecimal price) {

    }

    @Override
    public void weyPayRefund() {

    }

    @Override
    public void aliPayRefund(String trade_no, String out_trade_no, String reason, String returnUrl, BigDecimal price) {
        PayAlipayUtils payAlipayUtils = new PayAlipayUtils();
        try {
            AlipayTradeRefundRequest request = new AlipayTradeRefundRequest();//创建API对应的request类
            request.setBizContent("{" +
                    "\"out_trade_no\":\"20210708171331569350143233340P\"," +
                    "\"trade_no\":\"2021070822001417381433077659\"," +
                    "\"out_request_no\":\"20210708145709112413077422058T\"," +
                    "\"refund_amount\":\"0.01\"}"); //设置业务参数
            AlipayTradeRefundResponse response =  PayAlipayUtils.getHttpClient().execute(request);//通过alipayClient调用API，获得对应的response类
            System.out.print(response.getBody());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
