package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "GoblinNftGoodsSpuInfoVo", description = "NFT商品SPU详情[不包含具体SKU，SKU详情参见'GoblinNftGoodsSkuInfoVo']")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinNftGoodsSpuInfoVo implements Serializable, Cloneable {

    private static final long serialVersionUID = -3869909399504844722L;

    @ApiModelProperty(position = 11, value = "商品ID[64]")
    private String spuId;

    @ApiModelProperty(position = 37, value = "创作者")
    private String author;
    @ApiModelProperty(position = 37, value = "发行方")
    private String publisher;

    private static final GoblinNftGoodsSpuInfoVo obj = new GoblinNftGoodsSpuInfoVo();

    public static GoblinNftGoodsSpuInfoVo getNew() {
        try {
            return (GoblinNftGoodsSpuInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinNftGoodsSpuInfoVo();
        }
    }

    public GoblinNftGoodsSpuInfoVo copy(GoblinGoodsInfoVo source) {
        if (null == source) return this;
        this.setSpuId(source.getSpuId());
        this.setAuthor(source.getAuthor());
        this.setPublisher(source.getPublisher());
        return this;
    }

}
