package com.liquidnet.service.adam.controller.admin;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.service.adam.service.processor.*;
import com.liquidnet.service.base.ResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order = 90062)
@Api(tags = "DM")
@Slf4j
@Validated
@RestController
@RequestMapping("dm")
public class AdamDMAdminController extends AdamBaseController {
    @Autowired
    DMUserInformationProcessor dmUserInformationProcessor;
    @Autowired
    DMThirdPartsProcessor dmThirdPartsProcessor;
    @Autowired
    DMRealNameProcessor dmRealNameProcessor;
    @Autowired
    DMUserMemberProcessor dmUserMemberProcessor;
    @Autowired
    DMEntersProcessor dmEntersProcessor;
    @Autowired
    DMAddressesProcessor dmAddressesProcessor;
    @Autowired
    DMTracesInfoProcessor dmTracesInfoProcessor;
    @Autowired
    DMMemberOrderProcessor dmMemberOrderProcessor;
    @Autowired
    DMMemberCodeProcessor dmMemberCodeProcessor;
    @Autowired
    DMCollectionProcessor dmCollectionProcessor;

    @ApiOperationSupport(order = 10)
    @ApiOperation(value = "user")
    @GetMapping(value = {"user"})
    public ResponseDto<Object> dataMigrationForUser() {
        dmUserInformationProcessor.handler();
        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 20)
    @ApiOperation(value = "tpa")
    @GetMapping(value = {"tpa"})
    public ResponseDto<Object> dataMigrationForTpa() {
        dmThirdPartsProcessor.handler();
        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 30)
    @ApiOperation(value = "real")
    @GetMapping(value = {"real"})
    public ResponseDto<Object> dataMigrationForReal() {
        dmRealNameProcessor.handler();
        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 40)
    @ApiOperation(value = "vip")
    @GetMapping(value = {"vip"})
    public ResponseDto<Object> dataMigrationForVip() {
        dmUserMemberProcessor.handler();
        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 50)
    @ApiOperation(value = "traces")
    @GetMapping(value = {"traces"})
    public ResponseDto<Object> dataMigrationForTraces() {
        dmTracesInfoProcessor.handler();
        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 60)
    @ApiOperation(value = "enters")
    @GetMapping(value = {"enters"})
    public ResponseDto<Object> dataMigrationForEnters() {
        dmEntersProcessor.handler();
        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 70)
    @ApiOperation(value = "addr")
    @GetMapping(value = {"addr"})
    public ResponseDto<Object> dataMigrationForAddr() {
        dmAddressesProcessor.handler();
        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 80)
    @ApiOperation(value = "morder")
    @GetMapping(value = {"morder"})
    public ResponseDto<Object> dataMigrationForMOrder() {
        dmMemberOrderProcessor.handler();
        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 90)
    @ApiOperation(value = "mcode")
    @GetMapping(value = {"mcode"})
    public ResponseDto<Object> dataMigrationForMCode() {
        dmMemberCodeProcessor.handler();
        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 100)
    @ApiOperation(value = "collect")
    @GetMapping(value = {"collect"})
    public ResponseDto<Object> dataMigrationForCollect() {
        dmCollectionProcessor.handler();
        return ResponseDto.success();
    }
}
