use dev_ln_scene;
#创建集合
db.createCollection("GalaxyUserInfoVo");
db.createCollection("GalaxySeriesInfoVo");
db.createCollection("GalaxySeriesNftInfoVo");
db.createCollection("GalaxySeriesNftUploadVo");
db.createCollection("GalaxyNftOrderVo");
db.createCollection("GalaxyNftOrderBindVo");
db.createCollection("GalaxyNftOrderFailLogVo");
db.createCollection("GalaxyNftTradeVo");


#创建索引
db.GalaxyUserInfoVo.createIndex({userId:"hashed"});
db.GalaxySeriesInfoVo.createIndex({seriesCode:"hashed"});
db.GalaxySeriesNftInfoVo.createIndex({skuId:"hashed"});
db.GalaxySeriesNftUploadVo.createIndex({skuId:"hashed"});
db.GalaxyNftOrderVo.createIndex({nftOrderPayId:"hashed"});
db.GalaxyNftOrderBindVo.createIndex({nftOrderPayId:"hashed"});
db.GalaxyNftOrderFailLogVo.createIndex({nftOrderPayId:"hashed"});
db.GalaxyNftTradeVo.createIndex({nftId:"hashed"});

#创建分片
sh.enableSharding("dev_ln_scene");
sh.shardCollection("dev_ln_scene.GalaxyUserInfoVo",{"userId":"hashed"});
sh.shardCollection("dev_ln_scene.GalaxySeriesInfoVo",{"seriesCode":"hashed"});
sh.shardCollection("dev_ln_scene.GalaxySeriesNftInfoVo",{"skuId":"hashed"});
sh.shardCollection("dev_ln_scene.GalaxySeriesNftUploadVo",{"skuId":"hashed"});
sh.shardCollection("dev_ln_scene.GalaxyNftOrderVo",{"nftOrderPayId":"hashed"});
sh.shardCollection("dev_ln_scene.GalaxyNftOrderBindVo",{"nftOrderPayId":"hashed"});
sh.shardCollection("dev_ln_scene.GalaxyNftOrderFailLogVo",{"nftOrderPayId":"hashed"});
sh.shardCollection("dev_ln_scene.GalaxyNftTradeVo",{"nftId":"hashed"});