package com.liquidnet.service.dragon.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: DragonPayBaseReqDto
 * @Package com.liquidnet.service.dragon.dto
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/9 10:56
 */
@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class DragonPayBaseRespDto implements Serializable {
    private static final long serialVersionUID = -7785149250417660932L;
    private String code;

    private String orderCode;

    private Integer status;

    private String orderId;

    private String showUrl;

    private String returnUrl;

    private BigDecimal price;

    private PayData payData;

    private String payType;

    private String productId;

    //为了应对扫码支付错误码信息
    private String msg;
    //支付宝小程序tradeNo
    private String tradeNo;

    @Data
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public static class PayData{
        private String appId;

        private String nonceStr;

        private String timeStamp;

        @JsonProperty("package")
        private String packages;

        private String partnerId;

        private String prepayId;

        private String sign;

        private String mwebUrl;

        private String paySign;

        private String signType;

        private String redirectUrl;

        private String orderStr;

        private String orderId;

        private String orderToken;

        private String tradeNo;
    }
}
