package com.liquidnet.service.consumer.base.receiver;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.galaxy.dto.param.GalaxyUserRegisterReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyUserRegisterRespDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.stereotype.Component;

import java.util.HashMap;

@Slf4j
@Component
public class ConsumerGalaxyJsonNftUserRegisterReceiver extends AbstractBizRedisReceiver {
    @Value("${liquidnet.service.goblin.url}")
    private String serviceGoblinUrl;

    @Override
    protected boolean consumerMessageHandler(String msg) {
        boolean aBoolean = false;
        try {
            GalaxyUserRegisterReqDto textMessage = JsonUtils.fromJson(msg, GalaxyUserRegisterReqDto.class);
            if (textMessage == null) {
                aBoolean = true;
            } else {
                //执行计数
                ResponseDto<GalaxyUserRegisterRespDto> responseDto = this.userRegister(textMessage);
//                if(responseDto.isSuccess()){
                    aBoolean = true;
//                }
            }
        } catch (Exception e) {
            log.error("CONSUMER MSG EX_HANDLE ==> [{}]:{}", this.getRedisStreamKey(), msg, e);
        } finally {
            if (!aBoolean) {
                HashMap<String, String> map = CollectionUtil.mapStringString();
                map.put("message", msg);
                stringRedisTemplate.opsForStream().add(StreamRecords.mapBacked(map).withStreamKey(this.getRedisStreamKey()));
            }
        }
        return aBoolean;
    }

    @Override
    protected String getRedisStreamKey() {
        return MQConst.GalaxyQueue.JSON_NFT_USER_REGISTER.getKey();
    }

    @Override
    protected String getRedisStreamGroup() {
        return MQConst.GalaxyQueue.JSON_NFT_USER_REGISTER.getGroup();
    }

    /**
     * 执行用户注册
     * @param reqDto
     * @return
     */
    private ResponseDto<GalaxyUserRegisterRespDto> userRegister(GalaxyUserRegisterReqDto reqDto) {
        String postUrl = serviceGoblinUrl + "/goblin/nftUser/que/register";
        try {
            String postRespStr = HttpUtil.postJson(postUrl, JsonUtils.toJson(reqDto));
            ResponseDto responseDto = JsonUtils.fromJson(postRespStr, ResponseDto.class);
            return  responseDto;
        } catch (Exception e) {
            log.error("Ex.NFT开通数字账户:请求异常[url={},paramsStr={}],ex:{}", postUrl, JsonUtils.toJson(reqDto), e.getMessage());
            return ResponseDto.failure();
        }
    }
}
