package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.sweet.entity.SweetLostFoundItem;
import com.liquidnet.service.sweet.mapper.SweetLostFoundItemMapper;
import com.liquidnet.service.sweet.param.SweetLostFoundItemParam;
import com.liquidnet.service.sweet.service.ISweetLostFoundItemService;
import com.liquidnet.service.sweet.vo.SweetLostFoundItemVo;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 失物招领信息服务实现类
 *
 * @author liquidnet
 * @since 2025-01-18
 */
@Service
public class SweetLostFoundItemServiceImpl extends ServiceImpl<SweetLostFoundItemMapper, SweetLostFoundItem> implements ISweetLostFoundItemService {

    @Override
    public boolean publishItem(SweetLostFoundItemParam item) {
        if (item == null) {
            return false;
        }

        SweetLostFoundItem lostFoundItem = new SweetLostFoundItem();
        lostFoundItem.setItemId(IDGenerator.nextSnowId());
        lostFoundItem.setPerformanceId(item.getPerformanceId());
        lostFoundItem.setItemType(item.getItemType());
        lostFoundItem.setPickupLocation(item.getPickupLocation());
        lostFoundItem.setPickupDate(item.getPickupDate());
        lostFoundItem.setDescription(item.getDescription());
        lostFoundItem.setItemImage(item.getItemImage());

        return baseMapper.insert(lostFoundItem) > 0;
    }

    @Override
    public boolean editItem(SweetLostFoundItemParam item) {
        if (item == null || item.getId() == null) {
            return false;
        }

        SweetLostFoundItem existingItem = SweetLostFoundItem.getNew();
        // 更新实体类字段
        existingItem.setId(item.getId());
        existingItem.setPerformanceId(item.getPerformanceId());
        existingItem.setItemType(item.getItemType());
        existingItem.setPickupLocation(item.getPickupLocation());
        existingItem.setPickupDate(item.getPickupDate());
        existingItem.setDescription(item.getDescription());
        existingItem.setItemImage(item.getItemImage());

        return baseMapper.updateById(existingItem) > 0;
    }

    @Override
    public boolean deleteItem(Long id) {
        if (id == null) {
            return false;
        }

        // 检查物品是否存在
        SweetLostFoundItem item = baseMapper.selectById(id);
        if (item == null || item.getIsDeleted() == 1) {
            return false;
        }

        item.setIsDeleted(1);
        return baseMapper.updateById(item) > 0;
    }

    @Override
    public SweetLostFoundItemVo getItemDetail(Long id) {
        if (id == null) {
            return null;
        }

        SweetLostFoundItem item = baseMapper.selectById(id);
        if (item == null || item.getIsDeleted() == 1) {
            return null;
        }

        SweetLostFoundItemVo vo = new SweetLostFoundItemVo();
        BeanUtils.copyProperties(item, vo);
        return vo;
    }

    @Override
    public List<SweetLostFoundItemVo> getItemList(Integer itemType, String performanceId) {
        QueryWrapper<SweetLostFoundItem> queryWrapper = new QueryWrapper<>();

        // 过滤逻辑删除的记录
        queryWrapper.eq("is_deleted", 0);

        // 根据演出ID查询
        queryWrapper.eq("performance_id", performanceId.trim());

        // 根据物品类型查询
        if (itemType != null) {
            queryWrapper.eq("item_type", itemType);
        }

        // 排序：按创建时间降序排列
        queryWrapper.orderByDesc("create_time");

        // 执行查询
        List<SweetLostFoundItem> items = baseMapper.selectList(queryWrapper);

        // 转换为VO对象列表
        return items.stream()
                .map(item -> {
                    SweetLostFoundItemVo vo = new SweetLostFoundItemVo();
                    BeanUtils.copyProperties(item, vo);
                    return vo;
                })
                .collect(Collectors.toList());
    }
}