DROP TABLE IF EXISTS `goblin_list`;
CREATE TABLE `goblin_list`
(
    `mid`         bigint UNSIGNED NOT NULL AUTO_INCREMENT,
    `list_id`     varchar(64)          DEFAULT '' COMMENT '名单id',
    `uid`         varchar(64)          DEFAULT '' COMMENT '用户id',
    `name`        varchar(64)          DEFAULT '' COMMENT '名单名称',
    `white_type`  int                  DEFAULT 1 COMMENT '白名单类型[0-会员|1-指定用户]',
    `white_url`   varchar(512)         DEFAULT '' COMMENT '白名单xls地址',
    `advance_min` int                  DEFAULT 0 COMMENT '提前购买时间',
    `black_type`  int                  DEFAULT 1 COMMENT '黑名单类型[0-会员|1-指定用户]',
    `black_url`   varchar(512)         DEFAULT '' COMMENT '黑名单xls地址',
    `comment`     varchar(255)         DEFAULT '' COMMENT '补充字段',
    `created_at`  datetime        NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at`  datetime        NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`) USING BTREE
) ENGINE = InnoDB
  AUTO_INCREMENT = 1
  CHARACTER SET = utf8mb4
  COLLATE = utf8mb4_unicode_ci COMMENT = '商城-名单表'
  ROW_FORMAT = DYNAMIC;


DROP TABLE IF EXISTS `goblin_list_details`;
CREATE TABLE `goblin_list_details`
(
    `mid`        bigint UNSIGNED NOT NULL AUTO_INCREMENT,
    `list_id`    varchar(64)          DEFAULT '' COMMENT '名单id',
    `spu_id`     varchar(64)          DEFAULT '' COMMENT 'spuId',
    `sku_id`     varchar(64)          DEFAULT '' COMMENT 'skuId',
    `comment`    varchar(255)         DEFAULT '' COMMENT '补充字段',
    `created_at` datetime        NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at` datetime        NULL DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`) USING BTREE
) ENGINE = InnoDB
  AUTO_INCREMENT = 1
  CHARACTER SET = utf8mb4
  COLLATE = utf8mb4_unicode_ci COMMENT = '商城-名单详情表'
  ROW_FORMAT = DYNAMIC;


# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_goods_sku_extra;
create table goblin_goods_sku_extra
(
    mid            bigint auto_increment primary key,
    sku_id         varchar(64)  not null,
    ar_url_ios     varchar(256) null comment '单品AR文件URL-iOS版',
    ar_url_android varchar(256) null comment '单品AR文件URL-android版',

    del_flg        char default '0' comment '删除标记[0-未删除|1删除]',
    created_by     varchar(64)  not null,
    created_at     datetime     not null,
    updated_by     varchar(64)  null,
    updated_at     datetime     null,
    deleted_by     varchar(64)  null,
    deleted_at     datetime     null,
    comment        varchar(500)
) engine = InnoDB comment '商品单品扩展信息';

create index idx_ggse_sku_id on goblin_goods_sku_extra (sku_id);
# -- >>------------------------------------------------------------------------------------