package com.liquidnet.service.goblin.service.impl.manage;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.PagedResult;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtGoodsSkuArAddParam;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtGoodsSkuArFilterParam;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtGoodsSkuArListVo;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreMgtGoodsSkuExtraService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.QueueUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;

@Slf4j
@Service
public class GoblinStoreMgtGoodsSkuExtraServiceImpl implements IGoblinStoreMgtGoodsSkuExtraService {
    @Autowired
    private QueueUtils queueUtils;
    @Autowired
    private GoblinMongoUtils goblinMongoUtils;
    @Autowired
    private GoblinRedisUtils goblinRedisUtils;

    @Override
    public PagedResult<GoblinStoreMgtGoodsSkuArListVo> skuArList(GoblinStoreMgtGoodsSkuArFilterParam mgtGoodsSkuExtraFilterParam) {
        return goblinMongoUtils.getSkuArList(mgtGoodsSkuExtraFilterParam);
    }

    @Override
    public boolean skuArAddEdit(String uid, GoblinStoreMgtGoodsSkuArAddParam mgtGoodsSkuArAddParam, boolean editFlg) {
        LocalDateTime now = LocalDateTime.now();
        String skuId = mgtGoodsSkuArAddParam.getSkuId();
        String arUrlIos = mgtGoodsSkuArAddParam.getArUrlIos();
        String arUrlAndroid = mgtGoodsSkuArAddParam.getArUrlAndroid();

        if (goblinMongoUtils.updateGoodsSkuInfoVoForArUrl(skuId, uid, now, arUrlIos, arUrlAndroid, editFlg)) {
            log.info("商品管理:藏品AR:{}[UID={},PARAMS={}]", editFlg ? "编辑" : "添加", uid, JsonUtils.toJson(mgtGoodsSkuArAddParam));
            goblinRedisUtils.delGoodsSkuInfoVo(skuId);
            goblinRedisUtils.delGoodsSkuInfoVoByUnShelves(skuId);

            LinkedList<String> toMqSqls = CollectionUtil.linkedListString();
            LinkedList<Object[]> addEditGoodsSkuExtraObjs = CollectionUtil.linkedListObjectArr();
            if (editFlg) {
                toMqSqls.add(SqlMapping.get("goblin_goods_sku_extra.edit_ar"));
                addEditGoodsSkuExtraObjs.add(new Object[]{arUrlIos, arUrlAndroid, uid, now, skuId});
            } else {
                toMqSqls.add(SqlMapping.get("goblin_goods_sku_extra.add_ar"));
                addEditGoodsSkuExtraObjs.add(new Object[]{skuId, arUrlIos, arUrlAndroid, uid, now});
            }
            queueUtils.sendMsgByRedis(MQConst.GoblinQueue.SQL_GOODS.getKey(), SqlMapping.gets(toMqSqls, addEditGoodsSkuExtraObjs));
            return true;
        }
        return false;
    }

    @Override
    public boolean skuArDel(String uid, List<String> skuIdList) {
        return false;
    }
}
