package com.liquidnet.service.goblin.dto.manage;

import com.liquidnet.service.goblin.dto.GoblinGoodsSpecDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@ApiModel(value = "GoblinStoreMgtGoodsAddSkuParam", description = "商品管理:添加商品:添加SKU入参")
@Data
public class GoblinStoreMgtGoodsAddSkuParam implements Serializable {
    private static final long serialVersionUID = 6657596593310537491L;
    /** ---------------------------- 规格信息 ---------------------------- **/

    @ApiModelProperty(position = 11, value = "单品默认图片的url[256]")
    private String skuPic;
    @ApiModelProperty(position = 12, value = "单品规格信息")
    private List<GoblinGoodsSpecDto> skuSpecList;
    @ApiModelProperty(position = 13, value = "单品价格[20,2]")
    private BigDecimal price;
    @ApiModelProperty(position = 14, value = "单品会员价格[20,2]")
    private BigDecimal priceMember;
    @ApiModelProperty(position = 15, value = "单品的重量[20,2]")
    private BigDecimal weight;
    @ApiModelProperty(position = 16, value = "ISBN，针对CD/图书等[100]")
    private String skuIsbn;
    @ApiModelProperty(position = 17, value = "购买限制[0-全部用户|1-仅会员|2-指定用户]")
    private String buyFactor;
    @ApiModelProperty(position = 18, value = "购买限制为2-指定用户时必填指定文件地址")
    private String buyLimit;
}
