package com.liquidnet.service.goblin.service.manage;

import com.liquidnet.service.base.PagedResult;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtGoodsActionParam;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtGoodsAddParam;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtGoodsFilterParam;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtGoodsInfoVo;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtGoodsListVo;

public interface IGoblinstoreMgtGoodsService {
    /**
     * 商品管理:SPU列表
     *
     * @param storeMgtGoodsFilterParam GoblinStoreMgtGoodsFilterParam
     * @return PagedResult<GoblinStoreMgtGoodsVo>
     */
    PagedResult<GoblinStoreMgtGoodsListVo> goodsList(GoblinStoreMgtGoodsFilterParam storeMgtGoodsFilterParam);

    /**
     * 商品管理:添加SPU
     *
     * @param storeMgtGoodsAddParam GoblinStoreMgtGoodsAddParam
     */
    void goodsAdd(GoblinStoreMgtGoodsAddParam storeMgtGoodsAddParam);

    /**
     * 商品管理:SPU详情
     *
     * @param spuId 商品ID
     * @return GoblinStoreMgtGoodsInfoVo
     */
    GoblinStoreMgtGoodsInfoVo goodsInfo(String spuId);

    /**
     * 商品管理:编辑SPU
     *
     * @param storeMgtGoodsAddParam GoblinStoreMgtGoodsAddParam
     */
    void goodsEdit(GoblinStoreMgtGoodsAddParam storeMgtGoodsAddParam);

    /**
     * 商品管理:上架商品
     *
     * @param storeMgtGoodsActionParam GoblinStoreMgtGoodsActionParam
     */
    void goodsOnshelves(GoblinStoreMgtGoodsActionParam storeMgtGoodsActionParam);

    /**
     * 商品管理:下架商品
     *
     * @param storeMgtGoodsActionParam GoblinStoreMgtGoodsActionParam
     */
    void goodsUnshelves(GoblinStoreMgtGoodsActionParam storeMgtGoodsActionParam);

    /**
     * 商品管理:删除商品
     *
     * @param storeMgtGoodsActionParam GoblinStoreMgtGoodsActionParam
     */
    void goodsRemove(GoblinStoreMgtGoodsActionParam storeMgtGoodsActionParam);
}
