package com.liquidnet.service.goblin.dto.manage;

import com.liquidnet.commons.lang.constant.LnsRegex;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsInfoVo;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsSkuInfoVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.Pattern;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@ApiModel(value = "GoblinStoreMgtGoodsAddParam", description = "商品管理:添加商品入参")
@Data
public class GoblinStoreMgtGoodsAddParam implements Serializable {
    private static final long serialVersionUID = -5101611616626164702L;
    @ApiModelProperty(position = 10, required = false, value = "商品ID[编辑时必传]")
    private String spuId;
    @ApiModelProperty(position = 11, required = true, value = "店铺ID")
    private String storeId;

    /** ---------------------------- 基本信息 ---------------------------- **/

    @ApiModelProperty(position = 12, required = true, value = "商品名称[128]")
    private String name;

    @ApiModelProperty(position = 13, required = true, value = "商品一级分类ID[30]")
    private String cateFid;
    @ApiModelProperty(position = 14, required = true, value = "商品二级分类ID[30]")
    private String cateSid;
    @ApiModelProperty(position = 15, required = true, value = "商品三级分类ID[30]")
    private String cateTid;

    @ApiModelProperty(position = 16, required = false, value = "商品简介[256]", example = "商品简介...")
    private String intro;

    @ApiModelProperty(position = 17, required = false, value = "商品标签列表")
    private List<String> tagList;
    @ApiModelProperty(position = 18, required = true, value = "商品图片列表")
    private List<String> imageList;
    @ApiModelProperty(position = 19, required = false, value = "商品视频地址")
    private String coverPic;
    @ApiModelProperty(position = 20, required = false, value = "商品视频地址")
    private String video;

    /** ---------------------------- 价格库存 ---------------------------- **/

    @ApiModelProperty(position = 21, required = true, value = "规格展现方式[1-常规|2-组合]", allowableValues = "1,2", example = "1")
    private String specMode;
    @ApiModelProperty(position = 22, required = true, value = "SKU规格信息")
    private List<GoblinStoreMgtGoodsAddSkuParam> skuParamList;
    @ApiModelProperty(position = 23, required = true, value = "物流模版", example = "松鼠德邦")
    private String logisticsTemplate;
    @ApiModelProperty(position = 24, required = false, value = "商品编码[默认为系统编码，也可手动输入商家自己的编码]")
    private String spuNo;

    /** ---------------------------- 商品介绍 ---------------------------- **/

    @ApiModelProperty(position = 25, required = true, value = "商品详情", example = "商品详情...")
    private String details;

    /** ---------------------------- 销售属性 ---------------------------- **/

    @ApiModelProperty(position = 26, required = true, value = "上架处理方式[1-等待手动上架|2-直接上架售卖|3-预约定时上架]", example = "1")
    private String shelvesHandle;
    @ApiModelProperty(position = 27, required = false, value = "预约上架时间[上架处理方式为3-预约定时上架时需要指定]")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_FULL, message = "预约上架时间格式有误")
    private String shelvesTime;
    @ApiModelProperty(position = 28, required = false, value = "商品有效期[YYYY-MM-DD]")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_YMD, message = "商品有效期格式有误")
    private String spuValidity;
    @ApiModelProperty(position = 29, required = true, value = "是否虚拟商品[0-否|1-是]", allowableValues = "0,1", example = "0")
    @Pattern(regexp = "\\b(0|1)\\b", message = "是否虚拟商品参数无效")
    private String virtualFlg;

    /** ---------------------------- 服务保障 ---------------------------- **/

    @ApiModelProperty(position = 30, required = false, value = "商品服务支持ID列表")
    private List<String> ssidList;

    /** ---------------------------- 专属标签 ---------------------------- **/

    @ApiModelProperty(position = 31, required = true, value = "商品关联音乐人、艺术家、IP列表")
    private List<String> extagList;

    public GoblinGoodsInfoVo initGoodsInfoVo() {
        GoblinGoodsInfoVo vo = GoblinGoodsInfoVo.getNew();
        vo.setStoreId(this.getStoreId());
        vo.setSpuId(IDGenerator.nextMilliId2());
        vo.setSpuNo(IDGenerator.nextTimeId2());
        vo.setName(this.getName());
//        vo.setSubtitle(null);
//        vo.setSellPrice(BigDecimal.ZERO);
//        vo.setPriceGe(BigDecimal.ZERO);
//        vo.setPriceLe(BigDecimal.ZERO);
        vo.setIntro(this.getIntro());
        vo.setDetails(this.getDetails());
        vo.setCoverPic(this.getCoverPic());
        vo.setVideo(this.getVideo());
        vo.setSpecMode(this.getSpecMode());
        vo.setCateFid(this.getCateFid());
        vo.setCateSid(this.getCateSid());
        vo.setCateTid(this.getCateTid());
//        vo.setStoreCateFid(null);
//        vo.setStoreCateSid(null);
//        vo.setStoreCateTid(null);
//        vo.setBrandId(null);
        vo.setShelvesHandle(this.getShelvesHandle());
        vo.setShelvesTime(this.getShelvesTime());
        vo.setSpuValidity(this.getSpuValidity());
        vo.setVirtualFlg(this.getVirtualFlg());
        vo.setStatus("1");
//        vo.setReason(null);
        vo.setShelvesStatus("0");
//        vo.setSpuAppear(null);
//        vo.setShelvesAt(null);
        vo.setImageList(this.getImageList());
        vo.setLogisticsTemplate(this.getLogisticsTemplate());
//        vo.setCreatedBy();
//        vo.setCreatedAt();
//        vo.setUpdatedBy();
//        vo.setUpdatedAt();
//        vo.setSpecVoList();
//        vo.setTagVoList();
//        vo.setServiceSupportVoList();
//        vo.setExtagVoList();
        return vo;
    }

    public void initGoodsSkuInfoVo(GoblinGoodsInfoVo goodsInfoVo, List<GoblinGoodsSkuInfoVo> vos) {
        for (GoblinStoreMgtGoodsAddSkuParam goodsAddSkuParam : this.getSkuParamList()) {
            GoblinGoodsSkuInfoVo vo = GoblinGoodsSkuInfoVo.getNew();
            vo.setSkuId(goodsInfoVo.getSpuId().concat(StringUtils.right(String.valueOf(System.nanoTime()), 5)));
            vo.setSpuId(goodsInfoVo.getSpuId());
//            vo.setSkuNo();
        }
    }
}
