package com.liquidnet.service.goblin.dto.manage;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsInfoVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@ApiModel(value = "GoblinStoreMgtDigitalGoodsAddParam", description = "商品管理:商品编辑:数字商品基本信息添加/编辑入参")
@Data
public class GoblinStoreMgtDigitalGoodsAddParam implements Serializable {
    private static final long serialVersionUID = -107018124207214457L;
    @ApiModelProperty(position = 10, required = true, value = "店铺ID")
    @NotNull(message = "店铺ID不能为空")
    private String storeId;
    @ApiModelProperty(position = 11, required = false, value = "商品ID[编辑时必传]")
    private String spuId;

    /**
     * ---------------------------- 基本信息 ----------------------------
     **/

    @ApiModelProperty(position = 12, required = true, value = "商品名称[36]")
    @NotBlank(message = "商品名称不能为空")
    @Size(max = 36, message = "商品名称长度超限")
    private String name;

    @ApiModelProperty(position = 14, required = true, value = "商品一级分类ID[30]")
    @NotBlank(message = "商品分类ID不能为空")
    private String cateFid;
    @ApiModelProperty(position = 15, required = true, value = "商品二级分类ID[30]")
    private String cateSid;
    @ApiModelProperty(position = 16, required = true, value = "商品三级分类ID[30]")
    private String cateTid;

    @ApiModelProperty(position = 17, required = false, value = "商品简介[256]", example = "商品简介...")
    @Size(max = 256, message = "商品简介内容过长")
    private String intro;

    @ApiModelProperty(position = 18, required = false, value = "商品标签列表")
    private List<String> tagList;

    @ApiModelProperty(position = 19, required = true, value = "注意事项[256]", example = "注意事项...")
//    @NotBlank(message = "注意事项不能为空")
    @Size(max = 256, message = "注意事项内容过长")
    private String attention;
    @ApiModelProperty(position = 20, required = true, value = "创作者[25]", example = "创作者...")
    @NotBlank(message = "创作者不能为空")
    @Size(max = 25, message = "创作者内容过长")
    private String author;
    @ApiModelProperty(position = 21, required = true, value = "发行方[25]", example = "发行方...")
    @NotBlank(message = "发行方不能为空")
    @Size(max = 25, message = "发行方内容过长")
    private String publisher;

    /**
     * 生成SPU
     *
     * @return GoblinGoodsInfoVo
     */
    public GoblinGoodsInfoVo initGoodsInfoVo() {
        GoblinGoodsInfoVo vo = GoblinGoodsInfoVo.getNew();
        vo.setStoreId(this.getStoreId());
        if (StringUtils.isBlank(this.getSpuId())) {
            vo.setSpuId(IDGenerator.nextMilliId2());
        } else {
            vo.setSpuId(this.getSpuId());
        }
        vo.setSpuNo(vo.getSpuId());
        vo.setSpuType(1);
        vo.setName(this.getName());
        vo.setSpecMode("1");
        vo.setCateFid(this.getCateFid());
        vo.setCateSid(this.getCateSid());
        vo.setCateTid(this.getCateTid());
        vo.setPriceGe(BigDecimal.ZERO);
        vo.setPriceLe(BigDecimal.ZERO);
        vo.setIntro(this.getIntro());
        vo.setAttention(this.getAttention());
        vo.setAuthor(this.getAuthor());
        vo.setPublisher(this.getPublisher());
        vo.setShelvesHandle("1");
        vo.setVirtualFlg("1");
        vo.setStatus("3");
        vo.setShelvesStatus("0");
        vo.setSpuAppear("1");
        vo.setDelFlg("0");
        vo.setSkuIdList(CollectionUtil.linkedListString());
        return vo;
    }

    /**
     * 编辑SPU参数整理
     *
     * @return GoblinGoodsInfoVo
     */
    public GoblinGoodsInfoVo initEditGoodsInfoVo() {
        GoblinGoodsInfoVo vo = GoblinGoodsInfoVo.getNew();
        vo.setSpuId(this.getSpuId());
        vo.setSpuType(1);
        vo.setName(this.getName());
        vo.setIntro(this.getIntro());
        vo.setCateFid(this.getCateFid());
        vo.setCateSid(this.getCateSid());
        vo.setCateTid(this.getCateTid());
        return vo;
    }
}
