package com.liquidnet.service.goblin.service.manage;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinOrderLogVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreOrderListVo;
import com.liquidnet.service.goblin.param.RefundCallbackParam;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import java.math.BigDecimal;

public interface IGoblinStoreOrderService {
    ResponseDto<PageInfo<GoblinStoreOrderListVo>> orderList(Integer page,
                                                            String orderCode,
                                                            Integer type,
                                                            String cst,
                                                            String cet,
                                                            String expressContacts,
                                                            String phone,
                                                            Integer status);

    ResponseDto<GoblinStoreOrderListVo> orderDetails(String orderId);

    ResponseDto<Boolean> orderCancel(String orderId);

    ResponseDto<Boolean> changeExpressPrice(String orderId, BigDecimal price);

    ResponseDto<Boolean> changeAddress(String orderId, String expressContacts, String expressPhone, String expressAddressDetail);

    ResponseDto<Boolean> changeSkuPrice(String orderId, String orderSkuId, BigDecimal price);

    ResponseDto<Boolean> refundOrderSku(String orderId, String orderSkuId, BigDecimal price);

    ResponseDto<Boolean> express(String orderId, String orderSkuIds,String mailNo,String uid);

    ResponseDto<Boolean> changeExpressMailNo(String orderId, String mailId,String mailNo);

}
