package com.liquidnet.service.goblin.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtGoodsInfoVo;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtGoodsListVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.math.BigDecimal;

@Getter
@Setter
@EqualsAndHashCode
public class GoblinStoreMgtGoodsListVoExcel implements Serializable, Cloneable {
    private static final long serialVersionUID = -5926827517337445529L;
    @ExcelProperty("店铺ID")
    private String storeId;
    @ExcelProperty("商品ID")
    private String spuId;
    @ExcelProperty("商品编码")
    private String spuNo;
    @ExcelProperty("封面图片")
    private String coverPic;
    @ExcelProperty("商品名称")
    private String name;
    @ExcelProperty("分类")
    private String cateMerge;
    @ExcelProperty("价格区间")
    private String priceRange;
    //    @ExcelProperty("审核状态")
//    private String status;
//    @ExcelProperty("审核拒绝原因")
//    private String reason;
    @ExcelProperty("上架状态")
    private String shelvesStatus;

    @ExcelProperty("总库存")
    private Integer totalStock;
    @ExcelProperty("剩余库存")
    private Integer surplusStock;


    private static final GoblinStoreMgtGoodsListVoExcel obj = new GoblinStoreMgtGoodsListVoExcel();

    public static GoblinStoreMgtGoodsListVoExcel getNew() {
        try {
            return (GoblinStoreMgtGoodsListVoExcel) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinStoreMgtGoodsListVoExcel();
        }
    }

    public GoblinStoreMgtGoodsListVoExcel copy(GoblinStoreMgtGoodsListVo source) {
        if (null == source) return this;
        this.setStoreId(source.getStoreId());
        this.setSpuId(source.getSpuId());
        this.setSpuNo(source.getSpuNo());
        this.setCoverPic(source.getCoverPic());
        this.setName(source.getName());
        this.setCateMerge(StringUtils.defaultString(source.getCateFid(), "") + "/"
                + StringUtils.defaultString(source.getCateSid(), "") + "/"
                + StringUtils.defaultString(source.getCateTid(), ""));
        this.setPriceRange("¥" + source.getPriceGe().toString() + " - ¥" + source.getPriceLe().toString());
        switch (source.getShelvesStatus()) {
            case "0":
                this.setShelvesStatus("待上架");break;
            case "1":
                this.setShelvesStatus("已下架");break;
            case "2":
                this.setShelvesStatus("违规");break;
            case "3":
                this.setShelvesStatus("已上架");break;
            default:
                this.setShelvesStatus("其它");break;
        }
        this.setTotalStock(source.getTotalStock());
        this.setSurplusStock(source.getSurplusStock());
        return this;
    }
}
