package com.liquidnet.service.goblin.dto.manage;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;
import java.util.List;

@ApiModel(value = "GoblinStorePurchaseItemParam")
@Data
public class GoblinStorePurchaseCommonParam {

    @ApiModelProperty(required = true, value = "商铺活动Id", example = "1")
    @NotBlank(message = "商铺活动Id不能为空")
    private String storeMarketId;
    @ApiModelProperty(required = true, value = "商铺Id", example = "1")
    @NotBlank(message = "商铺id不能为空")
    private String storeId;
    @ApiModelProperty(required = true, value = "spuId", example = "1")
    @NotBlank(message = "spuId不能空")
    private String spuId;
    @ApiModelProperty(required = true, value = "相关配置", example = "1")
    private List<GoblinStorePurchaseItemParam> goblinStorePurchaseItemParam;
}



