/**
 * $Id: PageControllerAdviceHandler.java 13332 2016-07-06 09:15:06Z anjiabin $
 * Copyright(C) 2014-2020 easegame, All Rights Reserved.
 */
package com.liquidnet.common.exception;

import com.liquidnet.common.exception.annotation.PageErrorController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

/**
 * Created by Administrator on 2017/6/17.
 */
@ControllerAdvice(annotations = PageErrorController.class)
public class PageControllerAdviceHandler {
    private final Logger logger = LoggerFactory.getLogger(PageControllerAdviceHandler.class);

    @ExceptionHandler
    public String handleException(Model model, Exception exception) {
        logger.error("PageController errer:{}", exception);
        model.addAttribute("msg", exception.getMessage());
        if (exception instanceof LiquidnetServiceException) {
            LiquidnetServiceException ex = (LiquidnetServiceException) exception;
            logger.error("PageController errorCode:{}  errorMsg:{}", ex.errorCode(), ex.getMessage());
        }
        return "500";
    }
}
